/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.model.util;

import java.awt.Color;
import org.pentaho.chart.model.AreaPlot;
import org.pentaho.chart.model.Axis;
import org.pentaho.chart.model.BarPlot;
import org.pentaho.chart.model.ChartModel;
import org.pentaho.chart.model.ChartTitle;
import org.pentaho.chart.model.CssStyle;
import org.pentaho.chart.model.DialPlot;
import org.pentaho.chart.model.LinePlot;
import org.pentaho.chart.model.Palette;
import org.pentaho.chart.model.PiePlot;
import org.pentaho.chart.model.Plot;
import org.pentaho.chart.model.ScatterPlot;
import org.pentaho.chart.model.StyledText;
import org.pentaho.chart.model.Theme;
import org.pentaho.chart.model.TwoAxisPlot;
import org.pentaho.chart.model.util.ChartSerializer;

public class GenChartDefinition {
    public static void main(String[] args) {
        if (args == null || args.length <= 0) {
            System.out.println("========================");
            System.out.println("USAGE: GenChartDefinition");
            System.out.println("========================");
            System.out.println();
            System.out.println("      GenChartDefinition will accept any number of space separated strings as ");
            System.out.println("      arguments, and will print to system out a full featured chart definition in XML. ");
            System.out.println("      Valid chart strings are: ");
            System.out.println("      BAR LINE HBAR PIE AREA DIAL SCATTER ");
            System.out.println();
            System.out.println("      GenChartDefinition string1 string2 stringN ...");
            System.out.println();
            System.out.println();
        }
        block9: for (String chart : args) {
            charts type = charts.valueOf(chart);
            switch (type) {
                case BAR: {
                    GenChartDefinition.genBarChartDefinition();
                    continue block9;
                }
                case HBAR: {
                    GenChartDefinition.genHorizontalBarChartDefinition();
                    continue block9;
                }
                case LINE: {
                    GenChartDefinition.genLineChartDefinition();
                    continue block9;
                }
                case PIE: {
                    GenChartDefinition.genPieChartDefinition();
                    continue block9;
                }
                case AREA: {
                    GenChartDefinition.genAreaChartDefinition();
                    continue block9;
                }
                case DIAL: {
                    GenChartDefinition.genDialChartDefinition();
                    continue block9;
                }
                case SCATTER: {
                    GenChartDefinition.genScatterChartDefinition();
                    continue block9;
                }
            }
        }
    }

    private static void genDialChartDefinition() {
        ChartModel chartModel = new ChartModel();
        GenChartDefinition.fillStandardFeatures(chartModel);
        DialPlot dialPlot = new DialPlot();
        dialPlot.setAnimate(true);
        dialPlot.setBackground(0xFFFFF0);
        dialPlot.setOpacity(Float.valueOf(0.75f));
        dialPlot.getScale().addRange(new DialPlot.DialRange(0, 75, Color.RED.getRGB()));
        dialPlot.getScale().addRange(new DialPlot.DialRange(75, 125, Color.YELLOW.getRGB()));
        dialPlot.getScale().addRange(new DialPlot.DialRange(125, 200, Color.GREEN.getRGB()));
        dialPlot.getAnnotation().setText("annotation");
        dialPlot.getAnnotation().setFont("verdana", 10, CssStyle.FontStyle.ITALIC, CssStyle.FontWeight.BOLD);
        dialPlot.setAnimate(true);
        chartModel.setPlot(dialPlot);
        String result = ChartSerializer.serialize(chartModel, ChartSerializer.ChartSerializationFormat.XML);
        System.out.println(result);
    }

    private static void genAreaChartDefinition() {
        ChartModel chartModel = new ChartModel();
        GenChartDefinition.fillStandardFeatures(chartModel);
        AreaPlot areaPlot = new AreaPlot();
        GenChartDefinition.fillTwoAxisFeatures(areaPlot);
        areaPlot.setBackground(0xFFFFF0);
        areaPlot.setOpacity(Float.valueOf(0.75f));
        areaPlot.setPalette(new Palette(4369, 0x222222, 0x333333));
        chartModel.setPlot(areaPlot);
        String result = ChartSerializer.serialize(chartModel, ChartSerializer.ChartSerializationFormat.XML);
        System.out.println(result);
    }

    private static void genPieChartDefinition() {
        ChartModel chartModel = new ChartModel();
        GenChartDefinition.fillStandardFeatures(chartModel);
        PiePlot piePlot = new PiePlot();
        piePlot.setBackground(0xFFFFF0);
        piePlot.setStartAngle(65);
        piePlot.setOpacity(Float.valueOf(0.75f));
        piePlot.setPalette(new Palette(8915471, 11573867, 0x772200, 12922637, 1195394, 4851814, 0xFFAA00, 2001619, 0xAA6611, 0x772200, 9119796, 0x333333));
        piePlot.setAnimate(true);
        piePlot.getLabels().setFont("monospace", 8, CssStyle.FontStyle.OBLIQUE, CssStyle.FontWeight.BOLD);
        chartModel.setPlot(piePlot);
        String result = ChartSerializer.serialize(chartModel, ChartSerializer.ChartSerializationFormat.XML);
        System.out.println(result);
    }

    private static void genLineChartDefinition() {
        ChartModel chartModel = new ChartModel();
        GenChartDefinition.fillStandardFeatures(chartModel);
        LinePlot linePlot = new LinePlot();
        GenChartDefinition.fillTwoAxisFeatures(linePlot);
        linePlot.setBackground(0xFFFFF0);
        linePlot.setFlavor(LinePlot.LinePlotFlavor.THREED);
        linePlot.setOpacity(Float.valueOf(0.75f));
        linePlot.setLineWidth(5);
        linePlot.setPalette(new Palette(8915471, 11573867, 0x772200, 12922637, 1195394, 4851814, 0xFFAA00, 2001619, 0xAA6611, 0x772200, 9119796, 0x333333));
        chartModel.setPlot(linePlot);
        String result = ChartSerializer.serialize(chartModel, ChartSerializer.ChartSerializationFormat.XML);
        System.out.println(result);
    }

    private static void genHorizontalBarChartDefinition() {
        ChartModel chartModel = new ChartModel();
        GenChartDefinition.fillStandardFeatures(chartModel);
        BarPlot barPlot = GenChartDefinition.fillBarPlot(Plot.Orientation.HORIZONTAL);
        chartModel.setPlot(barPlot);
        String result = ChartSerializer.serialize(chartModel, ChartSerializer.ChartSerializationFormat.XML);
        System.out.println(result);
    }

    private static void genBarChartDefinition() {
        ChartModel chartModel = new ChartModel();
        GenChartDefinition.fillStandardFeatures(chartModel);
        BarPlot barPlot = GenChartDefinition.fillBarPlot(Plot.Orientation.VERTICAL);
        chartModel.setPlot(barPlot);
        String result = ChartSerializer.serialize(chartModel, ChartSerializer.ChartSerializationFormat.XML);
        System.out.println(result);
    }

    public static void genScatterChartDefinition() {
        ChartModel chartModel = new ChartModel();
        GenChartDefinition.fillStandardFeatures(chartModel);
        ScatterPlot scPlot = new ScatterPlot();
        GenChartDefinition.fillTwoAxisFeatures(scPlot);
        scPlot.setPalette(new Palette(8915471, 11573867, 0x772200, 12922637, 1195394, 4851814, 0xFFAA00, 2001619, 0xAA6611, 0x772200, 9119796, 0x333333));
        scPlot.setBackground(7755920);
        scPlot.setOpacity(Float.valueOf(0.75f));
        scPlot.setOrientation(Plot.Orientation.VERTICAL);
        chartModel.setPlot(scPlot);
        String result = ChartSerializer.serialize(chartModel, ChartSerializer.ChartSerializationFormat.XML);
        System.out.println(result);
    }

    private static void fillStandardFeatures(ChartModel chartModel) {
        chartModel.setChartEngineId("JFreeChart");
        chartModel.setTheme(Theme.ChartTheme.THEME4);
        chartModel.setBackground(16775885);
        chartModel.setBorderColor(9991764);
        chartModel.setBorderVisible(true);
        chartModel.setBorderWidth(5);
        chartModel.getTitle().setText("Chart Title");
        chartModel.getTitle().setAlignment(CssStyle.TextAlignment.CENTER);
        chartModel.getTitle().setColor(0xFFAA00);
        chartModel.getTitle().setFont("courier", 20, CssStyle.FontStyle.OBLIQUE, CssStyle.FontWeight.BOLD);
        chartModel.getTitle().setBackgroundColor(16775885);
        chartModel.getTitle().setLocation(ChartTitle.TitleLocation.TOP);
        chartModel.getLegend().setVisible(true);
        chartModel.getLegend().setBorderColor(8915471);
        chartModel.getLegend().setBorderVisible(true);
        chartModel.getLegend().setBorderWidth(10);
        chartModel.getLegend().setFont("verdana", 18, CssStyle.FontStyle.ITALIC, CssStyle.FontWeight.BOLD);
        StyledText subtitle = new StyledText("subtitle", "monospace", CssStyle.FontStyle.ITALIC, CssStyle.FontWeight.BOLD, 12);
        subtitle.setColor(65280);
        subtitle.setBackgroundColor(255);
        chartModel.getSubtitles().add(subtitle);
    }

    private static void fillTwoAxisFeatures(TwoAxisPlot plot) {
        plot.getHorizontalAxis().setLabelOrientation(Axis.LabelOrientation.DIAGONAL);
        plot.getHorizontalAxis().getLegend().setText("xAxis");
        plot.getHorizontalAxis().getLegend().setColor(0x772200);
        plot.getHorizontalAxis().getLegend().setFont("san-serif", 10, CssStyle.FontStyle.NORMAL, CssStyle.FontWeight.NORMAL);
        plot.getHorizontalAxis().getLegend().setAlignment(CssStyle.TextAlignment.LEFT);
        plot.getHorizontalAxis().getLegend().setBackgroundColor(0xFFAA00);
        plot.getVerticalAxis().getLegend().setText("yAxis");
        plot.getVerticalAxis().getLegend().setColor(0x772200);
        plot.getVerticalAxis().getLegend().setFont("san-serif", 12, CssStyle.FontStyle.OBLIQUE, CssStyle.FontWeight.BOLD);
        plot.getVerticalAxis().getLegend().setAlignment(CssStyle.TextAlignment.RIGHT);
        plot.getVerticalAxis().getLegend().setBackgroundColor(0xFFAA00);
    }

    private static BarPlot fillBarPlot(Plot.Orientation o) {
        BarPlot barPlot = new BarPlot();
        barPlot.setOrientation(o);
        GenChartDefinition.fillTwoAxisFeatures(barPlot);
        barPlot.setBackground(0xFFFFF0);
        barPlot.setFlavor(BarPlot.BarPlotFlavor.PLAIN);
        barPlot.setOpacity(Float.valueOf(0.75f));
        barPlot.setPalette(new Palette(8915471, 11573867, 0x772200, 12922637, 1195394, 4851814, 0xFFAA00, 2001619, 0xAA6611, 0x772200, 9119796, 0x333333));
        return barPlot;
    }

    private static enum charts {
        BAR,
        LINE,
        HBAR,
        PIE,
        AREA,
        DIAL,
        SCATTER;

    }
}

