/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.model.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.pentaho.chart.model.BarPlot;
import org.pentaho.chart.model.ChartDataDefinition;
import org.pentaho.chart.model.ChartLegend;
import org.pentaho.chart.model.ChartModel;
import org.pentaho.chart.model.CssStyle;
import org.pentaho.chart.model.DialPlot;
import org.pentaho.chart.model.LinePlot;
import org.pentaho.chart.model.PiePlot;
import org.pentaho.chart.model.Plot;
import org.pentaho.chart.model.TwoAxisPlot;
import org.pentaho.chart.model.util.AxisConverter;
import org.pentaho.chart.model.util.ChartModelConverter;
import org.pentaho.chart.model.util.ChartTitleConverter;
import org.pentaho.chart.model.util.CssStylesConverter;
import org.pentaho.chart.model.util.GridConverter;
import org.pentaho.chart.model.util.PaletteConverter;
import org.pentaho.chart.model.util.ScaleConverter;
import org.pentaho.chart.model.util.StyledTextConverter;

public class ChartSerializer {
    private static XStream jsonChartWriter = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
    private static XStream jsonChartDefWriter = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
    private static XStream xmlChartWriter = new XStream((HierarchicalStreamDriver)new DomDriver());
    private static XStream xmlChartDefWriter = new XStream((HierarchicalStreamDriver)new DomDriver());

    public static String serialize(ChartModel model, ChartSerializationFormat outputFormat) {
        String result = null;
        switch (outputFormat) {
            case JSON: {
                result = jsonChartWriter.toXML((Object)model);
                break;
            }
            case XML: {
                result = xmlChartWriter.toXML((Object)model);
            }
        }
        return result;
    }

    public static ChartModel deSerialize(String input, ChartSerializationFormat inputFormat) {
        ChartModel chartModel = null;
        switch (inputFormat) {
            case JSON: {
                chartModel = (ChartModel)jsonChartWriter.fromXML(input);
                break;
            }
            case XML: {
                chartModel = (ChartModel)xmlChartWriter.fromXML(input);
            }
        }
        return chartModel;
    }

    public static String serializeDataDefinition(ChartDataDefinition def, ChartSerializationFormat outputFormat) {
        String result = null;
        switch (outputFormat) {
            case JSON: {
                result = jsonChartDefWriter.toXML((Object)def);
                break;
            }
            case XML: {
                result = xmlChartDefWriter.toXML((Object)def);
            }
        }
        return result;
    }

    public static ChartDataDefinition deSerializeDataDefinition(String input, ChartSerializationFormat inputFormat) {
        ChartDataDefinition chartDataDefinition = null;
        switch (inputFormat) {
            case JSON: {
                chartDataDefinition = (ChartDataDefinition)jsonChartDefWriter.fromXML(input);
                break;
            }
            case XML: {
                chartDataDefinition = (ChartDataDefinition)xmlChartDefWriter.fromXML(input);
            }
        }
        return chartDataDefinition;
    }

    static {
        jsonChartWriter.setMode(1001);
        jsonChartWriter.alias("chartModel", ChartModel.class);
        jsonChartWriter.useAttributeFor(CssStyle.class);
        jsonChartWriter.useAttributeFor(Plot.Orientation.class);
        jsonChartWriter.useAttributeFor(LinePlot.LinePlotFlavor.class);
        jsonChartWriter.useAttributeFor(BarPlot.BarPlotFlavor.class);
        jsonChartWriter.registerConverter((SingleValueConverter)new CssStylesConverter());
        jsonChartWriter.omitField(ChartLegend.class, "visible");
        jsonChartWriter.registerConverter((Converter)new StyledTextConverter());
        jsonChartWriter.registerConverter((Converter)new PaletteConverter());
        jsonChartWriter.registerConverter((Converter)new ScaleConverter());
        jsonChartWriter.registerConverter((Converter)new ChartModelConverter());
        jsonChartWriter.registerConverter((Converter)new AxisConverter());
        jsonChartWriter.registerConverter((Converter)new ChartTitleConverter());
        jsonChartWriter.registerConverter((Converter)new GridConverter());
        jsonChartWriter.useAttributeFor(PiePlot.class, "animate");
        jsonChartWriter.useAttributeFor(DialPlot.class, "animate");
        jsonChartWriter.useAttributeFor(PiePlot.class, "startAngle");
        jsonChartWriter.omitField(PiePlot.class, "slices");
        jsonChartWriter.omitField(PiePlot.class, "labels");
        jsonChartWriter.omitField(PiePlot.PieLabels.class, "visible");
        jsonChartWriter.omitField(TwoAxisPlot.class, "horizontalAxis");
        jsonChartWriter.omitField(TwoAxisPlot.class, "verticalAxis");
        jsonChartWriter.omitField(TwoAxisPlot.class, "grid");
        xmlChartWriter.setMode(1001);
        xmlChartWriter.alias("chartModel", ChartModel.class);
        xmlChartWriter.useAttributeFor(CssStyle.class);
        xmlChartWriter.useAttributeFor(Plot.Orientation.class);
        xmlChartWriter.useAttributeFor(LinePlot.LinePlotFlavor.class);
        xmlChartWriter.useAttributeFor(BarPlot.BarPlotFlavor.class);
        xmlChartWriter.registerConverter((SingleValueConverter)new CssStylesConverter());
        xmlChartWriter.omitField(ChartLegend.class, "visible");
        xmlChartWriter.registerConverter((Converter)new StyledTextConverter());
        xmlChartWriter.registerConverter((Converter)new PaletteConverter());
        xmlChartWriter.registerConverter((Converter)new ScaleConverter());
        xmlChartWriter.registerConverter((Converter)new ChartModelConverter());
        xmlChartWriter.registerConverter((Converter)new AxisConverter());
        xmlChartWriter.registerConverter((Converter)new ChartTitleConverter());
        xmlChartWriter.registerConverter((Converter)new GridConverter());
        xmlChartWriter.useAttributeFor(PiePlot.class, "animate");
        xmlChartWriter.useAttributeFor(DialPlot.class, "animate");
        xmlChartWriter.useAttributeFor(PiePlot.class, "startAngle");
        xmlChartWriter.omitField(PiePlot.class, "slices");
        xmlChartWriter.omitField(PiePlot.class, "labels");
        xmlChartWriter.omitField(PiePlot.PieLabels.class, "visible");
        xmlChartWriter.omitField(TwoAxisPlot.class, "horizontalAxis");
        xmlChartWriter.omitField(TwoAxisPlot.class, "verticalAxis");
        xmlChartWriter.omitField(TwoAxisPlot.class, "grid");
        jsonChartDefWriter.setMode(1001);
        jsonChartDefWriter.alias("chartDataModel", ChartDataDefinition.class);
        xmlChartDefWriter.setMode(1001);
        xmlChartDefWriter.alias("chartDataModel", ChartDataDefinition.class);
    }

    public static enum ChartSerializationFormat {
        JSON,
        XML;

    }
}

