/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.model;

import java.io.Serializable;
import org.pentaho.chart.model.Axis;
import org.pentaho.chart.model.Grid;
import org.pentaho.chart.model.NumericAxis;
import org.pentaho.chart.model.Plot;

public class TwoAxisPlot
extends Plot
implements Serializable {
    Grid grid = new Grid();
    Axis verticalAxis;
    Axis horizontalAxis;

    protected TwoAxisPlot(Axis horizontalAxis, NumericAxis verticalAxis) {
        this.verticalAxis = verticalAxis;
        this.horizontalAxis = horizontalAxis;
    }

    public Axis getHorizontalAxis() {
        return this.horizontalAxis;
    }

    public Axis getVerticalAxis() {
        return this.verticalAxis;
    }

    public Axis getDomainAxis() {
        return this.getOrientation() == Plot.Orientation.HORIZONTAL ? this.verticalAxis : this.horizontalAxis;
    }

    public NumericAxis getRangeAxis() {
        return (NumericAxis)(this.getOrientation() == Plot.Orientation.HORIZONTAL ? this.horizontalAxis : this.verticalAxis);
    }

    @Override
    public void setOrientation(Plot.Orientation orientation) {
        if (this.orientation != orientation) {
            Axis tmpAxis = this.verticalAxis;
            this.verticalAxis = this.horizontalAxis;
            this.horizontalAxis = tmpAxis;
        }
        super.setOrientation(orientation);
    }

    public Grid getGrid() {
        return this.grid;
    }
}

