/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.chart.data.FormattableName;
import org.pentaho.chart.data.IChartDataModel;
import org.pentaho.chart.data.IScalableDataModel;
import org.pentaho.chart.data.NamedValue;
import org.pentaho.chart.data.NamedValuesDataModel;

public class MultiSeriesDataModel
implements IChartDataModel,
IScalableDataModel {
    LinkedHashMap<FormattableName, DomainData> chartData = new LinkedHashMap();
    Number scalingFactor = 1;

    public void addValue(String categoryKey, String seriesKey, Number value) {
        this.addValue(categoryKey, null, seriesKey, null, value);
    }

    public void addValue(String categoryKey, String categoryFormatted, String seriesKey, String seriesFormatted, Number value) {
        NamedValue existingDataPoint;
        FormattableName category = new FormattableName(categoryKey, categoryFormatted);
        DomainData domainData = this.chartData.get(category);
        if (domainData == null) {
            domainData = new DomainData(category);
            if (this.chartData.size() > 0) {
                for (NamedValue existingDataPoint2 : this.chartData.values().iterator().next()) {
                    domainData.add(new NamedValue(existingDataPoint2.getName(), existingDataPoint2.getFormattedName(), null));
                }
            }
            this.chartData.put(category, domainData);
        }
        if ((existingDataPoint = domainData.getNamedValue(seriesKey)) == null) {
            domainData.add(new NamedValue(seriesKey, seriesFormatted, value));
            for (FormattableName tmpCategory : this.chartData.keySet()) {
                if (categoryKey.equals(tmpCategory.getKey())) continue;
                this.chartData.get(tmpCategory).add(new NamedValue(seriesKey, seriesFormatted, null));
            }
        } else if (existingDataPoint.getValue() == null) {
            existingDataPoint.setValue(value);
        } else if (value != null) {
            existingDataPoint.setValue(existingDataPoint.getValue().doubleValue() + value.doubleValue());
        }
    }

    public DomainData getDomainData(String domainName) {
        DomainData domainData = null;
        DomainData existingDomainData = this.chartData.get(new FormattableName(domainName));
        if (existingDomainData != null) {
            domainData = new DomainData(existingDomainData.domain);
            domainData.addAll(existingDomainData);
        }
        return domainData;
    }

    public List<DomainData> getDomainData() {
        ArrayList<DomainData> domainData = new ArrayList<DomainData>();
        for (Map.Entry<FormattableName, DomainData> mapEntry : this.chartData.entrySet()) {
            DomainData domain = new DomainData(mapEntry.getKey());
            domain.addAll(mapEntry.getValue());
            domainData.add(domain);
        }
        return domainData;
    }

    public SeriesData getSeriesData(String seriesKey) {
        DomainData firstCategoryDomainData;
        NamedValue existingDataPoint;
        SeriesData seriesData = null;
        if (this.chartData.size() > 0 && (existingDataPoint = (firstCategoryDomainData = this.chartData.values().iterator().next()).getNamedValue(seriesKey)) != null) {
            seriesData = new SeriesData(existingDataPoint.name);
            for (Map.Entry<FormattableName, DomainData> mapEntry : this.chartData.entrySet()) {
                FormattableName domain = mapEntry.getKey();
                Number value = mapEntry.getValue().getNamedValue((String)seriesKey).value;
                seriesData.add(new NamedValue(domain, value));
            }
        }
        return seriesData;
    }

    public List<SeriesData> getSeriesData() {
        ArrayList<SeriesData> seriesList = new ArrayList<SeriesData>();
        ArrayList<FormattableName> seriesNames = new ArrayList<FormattableName>();
        if (this.chartData.size() > 0) {
            DomainData firstCategoryDomainData = this.chartData.values().iterator().next();
            for (NamedValue namedValue : firstCategoryDomainData) {
                seriesNames.add(namedValue.name);
            }
        }
        for (FormattableName seriesName : seriesNames) {
            SeriesData seriesData = new SeriesData(seriesName);
            for (Map.Entry<FormattableName, DomainData> mapEntry : this.chartData.entrySet()) {
                FormattableName domainName = mapEntry.getKey();
                Number value = mapEntry.getValue().getNamedValue((String)seriesName.getKey()).value;
                seriesData.add(new NamedValue(domainName, value));
            }
            seriesList.add(seriesData);
        }
        return seriesList;
    }

    @Override
    public Number getScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public void setScalingFactor(Number scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public class DomainData
    extends NamedValuesDataModel {
        FormattableName domain;

        DomainData() {
        }

        DomainData(FormattableName domain) {
            this.domain = domain;
        }

        DomainData(String domainKey) {
            this.domain = new FormattableName(domainKey);
        }

        public List<String> getSeries() {
            return this.getNames();
        }

        public List<String> getFormattedSeries() {
            return this.getFormattedNames();
        }

        public FormattableName getDomainNameInstance() {
            return this.domain;
        }

        public String getDomainName() {
            return this.domain.getKey();
        }

        public String getDomainFormattedName() {
            return this.domain.getFormatted();
        }

        public void setDomainName(String domainName) {
            this.domain.setKey(domainName);
        }
    }

    public class SeriesData
    extends NamedValuesDataModel {
        FormattableName series;

        SeriesData() {
        }

        SeriesData(FormattableName series) {
            this.series = series;
        }

        SeriesData(String seriesKey) {
            this.series = new FormattableName(seriesKey);
        }

        public List<String> getDomains() {
            return this.getNames();
        }

        public List<String> getFormattedDomains() {
            return this.getFormattedNames();
        }

        public String getSeriesName() {
            return this.series.getKey();
        }

        public String getSeriesFormattedName() {
            return this.series.getFormatted();
        }

        public void setSeriesName(String seriesName) {
            this.series.setKey(seriesName);
        }
    }
}

