/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.core.ChartSeriesDataLinkInfo;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.util.messages.Messages;

public class ChartSeriesDataLinkInfoFactory {
    private static final Log logger = LogFactory.getLog(ChartSeriesDataLinkInfoFactory.class);
    private static final String COL_NAME = "column-name";
    private static final String COL_POS = "column-pos";
    private static final String SERIES = "series";

    private ChartSeriesDataLinkInfoFactory() {
    }

    public static ChartSeriesDataLinkInfo generateSeriesDataLinkInfo(ChartDocument chartDoc, ChartTableModel data) throws IllegalArgumentException {
        if (null == chartDoc) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartSeriesDataLinkInfoFactory.ERROR_0001_CHART_DOC_IS_NULL"));
        }
        if (null == data) {
            throw new IllegalArgumentException(Messages.getErrorString("ChartSeriesDataLinkInfoFactory.ERROR_0002_TABLE_MODEL_IS_NULL"));
        }
        ChartSeriesDataLinkInfo seriesDataLinkInfo = new ChartSeriesDataLinkInfo(data);
        ChartSeriesDataLinkInfoFactory.parseChartDocument(chartDoc, data, seriesDataLinkInfo);
        return seriesDataLinkInfo;
    }

    private static void parseChartDocument(ChartDocument chartDoc, ChartTableModel chartTableModel, ChartSeriesDataLinkInfo seriesDataLinkInfo) throws IllegalStateException {
        int dataColumnCount = chartTableModel.getColumnCount();
        if (dataColumnCount <= 0) {
            logger.warn((Object)Messages.getString("ChartSeriesDataLinkInfoFactory.WARN_DATA_IS_NULL"));
            return;
        }
        ChartElement rootChartElement = chartDoc.getRootElement();
        int seriesCount = 0;
        for (ChartElement currentChartElement = rootChartElement.getFirstChildItem(); currentChartElement != null; currentChartElement = currentChartElement.getNextItem()) {
            if (!SERIES.equalsIgnoreCase(currentChartElement.getTagName())) continue;
            boolean foundColumn = false;
            Object currentColumnNum = currentChartElement.getAttribute(COL_POS);
            Object currentColumnName = currentChartElement.getAttribute(COL_NAME);
            if (currentColumnNum != null) {
                try {
                    foundColumn = ChartSeriesDataLinkInfoFactory.processColumnPos(currentColumnNum, currentChartElement, chartTableModel, seriesDataLinkInfo);
                }
                catch (NumberFormatException ignore) {
                    logger.warn((Object)Messages.getString("ChartSeriesDataLinkInfoFactory.WARN_COLUMN_NUM_IS_NOT_VALID_INTEGER", (String)currentColumnNum, null));
                }
            }
            if (!foundColumn && currentColumnName != null) {
                foundColumn = ChartSeriesDataLinkInfoFactory.processColumnName(currentColumnName, currentChartElement, chartTableModel, seriesDataLinkInfo);
            }
            if (!foundColumn && currentColumnName == null && currentColumnNum == null && seriesCount < dataColumnCount) {
                seriesDataLinkInfo.setColumnNum(currentChartElement, seriesCount);
                foundColumn = true;
            }
            ++seriesCount;
        }
    }

    private static boolean processColumnPos(Object currentColumnNum, ChartElement currentChartElement, ChartTableModel chartTableModel, ChartSeriesDataLinkInfo seriesDataLinkInfo) throws NumberFormatException {
        boolean foundColumn = false;
        int columnNum = -1;
        columnNum = currentColumnNum instanceof String ? Integer.parseInt(((String)currentColumnNum).trim()) : ((Number)currentColumnNum).intValue();
        if (columnNum >= 0 && columnNum < chartTableModel.getColumnCount()) {
            seriesDataLinkInfo.setColumnNum(currentChartElement, columnNum);
            foundColumn = true;
        } else {
            logger.warn((Object)Messages.getString("ChartSeriesDataLinkInfoFactory.WARN_INCORECT_COLUMN_NUM", currentColumnNum.toString(), null));
        }
        return foundColumn;
    }

    private static boolean processColumnName(Object currentColumnName, ChartElement currentChartElement, ChartTableModel chartTableModel, ChartSeriesDataLinkInfo seriesDataLinkInfo) {
        String columnName = ((String)currentColumnName).trim();
        boolean foundColumn = false;
        int dataColumnCount = chartTableModel.getColumnCount();
        if (columnName.length() <= 0) {
            logger.warn((Object)Messages.getString("ChartSeriesDataLinkInfoFactory.WARN_COLUMN_NAME_IS_NULL"));
        } else {
            for (int i = 0; i < dataColumnCount; ++i) {
                String columnNameFromChartTableModel = chartTableModel.getColumnName(i);
                if (columnNameFromChartTableModel == null || !columnNameFromChartTableModel.equalsIgnoreCase(columnName)) continue;
                seriesDataLinkInfo.setColumnNum(currentChartElement, i);
                foundColumn = true;
                break;
            }
        }
        return foundColumn;
    }
}

