/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.model.CssStyle;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.font.FontSizeConstant;
import org.pentaho.reporting.libraries.css.keys.font.FontStyle;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.keys.font.FontWeight;
import org.pentaho.reporting.libraries.css.keys.font.RelativeFontSize;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class ChartUtils {
    private static Map<String, String> cssFamilyToAwtFamilyMap = new HashMap<String, String>();

    public static Font getFont(String fontFamily, CssStyle.FontStyle fontStyle, CssStyle.FontWeight fontWeight, Integer fontSize) {
        Font font = null;
        if (fontFamily != null) {
            if (cssFamilyToAwtFamilyMap.get(fontFamily) != null) {
                fontFamily = cssFamilyToAwtFamilyMap.get(fontFamily);
            }
            int styleFlag = 0;
            if (CssStyle.FontStyle.ITALIC.equals((Object)fontStyle)) {
                styleFlag |= 2;
            }
            if (CssStyle.FontWeight.BOLD.equals((Object)fontWeight)) {
                styleFlag |= 1;
            }
            font = new Font(fontFamily, styleFlag, fontSize == null ? 10 : fontSize);
        }
        return font;
    }

    public static Font getFont(ChartElement currentSeries) {
        Font font = null;
        if (currentSeries != null) {
            LayoutStyle layoutStyle = currentSeries.getLayoutStyle();
            CSSValue cssValue = layoutStyle.getValue(FontStyleKeys.FONT_FAMILY);
            String fontFamily = ChartUtils.getFontFamily(currentSeries);
            if (cssFamilyToAwtFamilyMap.get(fontFamily) != null) {
                fontFamily = cssFamilyToAwtFamilyMap.get(fontFamily);
            }
            if (fontFamily != null) {
                CSSValue fontStyle = ChartUtils.getFontStyle(currentSeries);
                CSSValue fontWeight = ChartUtils.getFontWeight(currentSeries);
                int styleFlag = 0;
                if (FontStyle.ITALIC.equals((Object)fontStyle)) {
                    styleFlag |= 2;
                }
                if (FontWeight.BOLD.equals((Object)fontWeight)) {
                    styleFlag |= 1;
                }
                font = new Font(fontFamily, styleFlag, 10);
                font = font.deriveFont(ChartUtils.getFontSize(currentSeries));
            }
        }
        return font;
    }

    public static String getFontFamily(ChartElement currentSeries) {
        String fontFamily = null;
        if (currentSeries != null) {
            LayoutStyle layoutStyle = currentSeries.getLayoutStyle();
            CSSValue cssValue = layoutStyle.getValue(FontStyleKeys.FONT_FAMILY);
            fontFamily = cssValue != null ? cssValue.getCSSText() : null;
        }
        return fontFamily;
    }

    public static CSSValue getFontWeight(ChartElement element) {
        LayoutStyle layoutStyle = element.getLayoutStyle();
        return layoutStyle.getValue(FontStyleKeys.FONT_WEIGHT);
    }

    public static CSSValue getFontStyle(ChartElement element) {
        LayoutStyle layoutStyle = element.getLayoutStyle();
        return layoutStyle.getValue(FontStyleKeys.FONT_STYLE);
    }

    public static float getFontSize(ChartElement element) {
        ChartElement parentElement;
        float size = 0.0f;
        LayoutStyle layoutStyle = element.getLayoutStyle();
        CSSValue fontSizeValue = layoutStyle.getValue(FontStyleKeys.FONT_SIZE);
        if (FontSizeConstant.XX_SMALL.equals((Object)fontSizeValue)) {
            size = 7.0f;
        } else if (FontSizeConstant.X_SMALL.equals((Object)fontSizeValue)) {
            size = 8.0f;
        } else if (FontSizeConstant.SMALL.equals((Object)fontSizeValue)) {
            size = 10.0f;
        } else if (FontSizeConstant.MEDIUM.equals((Object)fontSizeValue)) {
            size = 12.0f;
        } else if (FontSizeConstant.LARGE.equals((Object)fontSizeValue)) {
            size = 14.0f;
        } else if (FontSizeConstant.X_LARGE.equals((Object)fontSizeValue)) {
            size = 16.0f;
        } else if (FontSizeConstant.XX_LARGE.equals((Object)fontSizeValue)) {
            size = 18.0f;
        } else if (RelativeFontSize.SMALLER.equals((Object)fontSizeValue)) {
            parentElement = element.getParentItem();
            float parentSize = ChartUtils.getFontSize(parentElement);
            size = parentSize >= 7.0f && parentSize <= 18.0f ? parentSize - 2.0f : 10.0f;
        } else if (RelativeFontSize.LARGER.equals((Object)fontSizeValue)) {
            parentElement = element.getParentItem();
            float parentSize = ChartUtils.getFontSize(parentElement);
            size = parentSize >= 7.0f && parentSize <= 18.0f ? parentSize + 2.0f : 16.0f;
        } else if (fontSizeValue instanceof CSSNumericValue) {
            CSSNumericValue fontSize = (CSSNumericValue)fontSizeValue;
            CSSNumericType fontSizeType = fontSize.getNumericType();
            if (CSSNumericType.PERCENTAGE.equals((Object)fontSizeType)) {
                ChartElement parentElement2 = element.getParentItem();
                float parentSize = ChartUtils.getFontSize(parentElement2);
                if (parentSize >= 7.0f && parentSize <= 18.0f) {
                    size = parentSize * (float)fontSize.getValue() / 100.0f;
                }
            } else {
                size = (float)fontSize.getValue();
            }
        }
        if (size <= 0.0f) {
            parentElement = element.getParentItem();
            size = parentElement != null ? ChartUtils.getFontSize(parentElement) : 0.0f;
        }
        return size;
    }

    static {
        cssFamilyToAwtFamilyMap.put("monospace", "Monospaced");
        cssFamilyToAwtFamilyMap.put("serif", "Serif");
        cssFamilyToAwtFamilyMap.put("sans-serif", "SansSerif");
    }
}

