/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart;

import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.core.ChartSeriesDataLinkInfoFactory;
import org.pentaho.chart.core.parser.ChartXMLParser;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.model.CssStyle;
import org.pentaho.chart.model.StyledText;
import org.pentaho.chart.plugin.IChartPlugin;
import org.pentaho.chart.plugin.jfreechart.JFreeChartPlugin;
import org.pentaho.chart.plugin.openflashchart.OpenFlashChartPlugin;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.color.ColorStyleKeys;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.resolver.StyleResolver;
import org.pentaho.reporting.libraries.css.resolver.impl.DefaultStyleResolver;
import org.pentaho.reporting.libraries.css.values.CSSColorValue;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;

public class ChartFactory {
    private static final String UNIDENTIFIED = "Unable To Identify";
    private static List<IChartPlugin> chartPlugins = new ArrayList<IChartPlugin>();

    private ChartFactory() {
    }

    public static IChartPlugin getPlugin(String pluginId) {
        IChartPlugin plugin = null;
        for (IChartPlugin tmpPlugin : chartPlugins) {
            if (!tmpPlugin.getPluginId().equals(pluginId)) continue;
            plugin = tmpPlugin;
        }
        if (plugin == null && chartPlugins.size() == 0) {
            if ("JFreeChart".equals(pluginId)) {
                plugin = new JFreeChartPlugin();
            } else if ("OpenFlashChart".equals(pluginId)) {
                plugin = new OpenFlashChartPlugin();
            }
        }
        return plugin;
    }

    public static void loadDefaultChartPlugins(List<IChartPlugin> plugins) {
        chartPlugins = plugins;
    }

    public static ChartDocumentContext generateChart(URL chartURL) throws ResourceException {
        return ChartFactory.generateChart(chartURL, null);
    }

    public static ChartDocument getChartDocument(URL chartURL) throws ResourceException {
        return ChartFactory.getChartDocument(chartURL, true);
    }

    public static ChartDocument getChartDocument(URL chartURL, boolean cascadeStyles) throws ResourceException {
        ChartXMLParser chartParser = new ChartXMLParser();
        ChartDocument chart = chartParser.parseChartDocument(chartURL);
        if (cascadeStyles) {
            ChartDocumentContext cdc = new ChartDocumentContext(chart);
            ChartFactory.resolveStyles(chart, cdc);
        }
        return chart;
    }

    public static ChartDocumentContext generateChart(URL chartURL, ChartTableModel tableModel) throws ResourceException {
        return ChartFactory.generateChart(ChartFactory.getChartDocument(chartURL), tableModel);
    }

    public static ChartDocumentContext generateChart(ChartDocument chart, ChartTableModel tableModel) throws ResourceException {
        ChartDocumentContext cdc = new ChartDocumentContext(chart);
        if (tableModel != null) {
            cdc.setDataLinkInfo(ChartSeriesDataLinkInfoFactory.generateSeriesDataLinkInfo(chart, tableModel));
        }
        return cdc;
    }

    protected static StyleResolver getStyleResolver(ChartDocumentContext cdc) {
        DefaultStyleResolver sr = new DefaultStyleResolver();
        sr.initialize((DocumentContext)cdc);
        return sr;
    }

    protected static void resolveStyles(ChartDocument chart, ChartDocumentContext cdc) {
        StyleResolver sr = ChartFactory.getStyleResolver(cdc);
        for (ChartElement element = chart.getRootElement(); element != null; element = element.getNextDepthFirstItem()) {
            if (element.isStyleResolved()) continue;
            sr.resolveStyle((LayoutElement)element);
        }
    }

    private static void setElementFont(ChartElement chartElement, String fontFamily, Integer fontSize, CssStyle.FontStyle fontStyle, CssStyle.FontWeight fontWeight) {
        LayoutStyle style = chartElement.getLayoutStyle();
        if (fontFamily != null) {
            style.setValue(FontStyleKeys.FONT_FAMILY, (CSSValue)new CSSConstant(fontFamily));
        }
        if (fontSize != null) {
            style.setValue(FontStyleKeys.FONT_SIZE, (CSSValue)CSSNumericValue.createValue((CSSNumericType)CSSNumericType.PX, (double)fontSize.intValue()));
        }
        if (fontStyle != null) {
            style.setValue(FontStyleKeys.FONT_STYLE, (CSSValue)new CSSConstant(fontStyle.toString().toLowerCase()));
        }
        if (fontWeight != null) {
            style.setValue(FontStyleKeys.FONT_WEIGHT, (CSSValue)new CSSConstant(fontWeight.toString().toLowerCase()));
        }
    }

    private static ChartElement createTextElement(String elementName, StyledText styledText) {
        ChartElement chartElement = null;
        if (styledText != null && styledText.getText() != null) {
            chartElement = new ChartElement();
            chartElement.setTagName(elementName);
            chartElement.setText(styledText.getText());
            LayoutStyle style = chartElement.getLayoutStyle();
            ChartFactory.setElementFont(chartElement, styledText.getFontFamily(), styledText.getFontSize(), styledText.getFontStyle(), styledText.getFontWeight());
            if (styledText.getColor() != null) {
                style.setValue(ColorStyleKeys.COLOR, (CSSValue)new CSSColorValue(new Color((int)(styledText.getColor() & 0xFFFFFF))));
            }
        }
        return chartElement;
    }
}

