/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.reflection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.NamedStaticDataFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.DataPreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;
import org.pentaho.reporting.ui.datasources.reflection.DataSetQuery;
import org.pentaho.reporting.ui.datasources.reflection.Messages;
import org.pentaho.reporting.ui.datasources.reflection.ReflectionDataSourceModule;
import org.pentaho.reporting.ui.datasources.reflection.ReflectionPreviewWorker;

public class ReflectionDataSourceEditor
extends CommonDialog {
    private static final ResourceBundleSupport messages = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.ui.datasources.reflection.messages", ObjectUtilities.getClassLoader(ReflectionDataSourceModule.class));
    private JList queryNameList;
    private JTextField queryNameTextField;
    private JTextArea queryTextArea;
    private Map<String, DataSetQuery> queries;
    private boolean inQueryNameUpdate;
    private boolean inModifyingQueryNameList;
    private PreviewAction previewAction;

    public ReflectionDataSourceEditor() {
        this.init();
    }

    public ReflectionDataSourceEditor(Dialog aOwner) {
        super(aOwner);
        this.init();
    }

    public ReflectionDataSourceEditor(Frame aOwner) {
        super(aOwner);
        this.init();
    }

    protected void init() {
        this.setModal(true);
        this.setTitle(messages.getString("ReflectionDataSourceEditor.Title"));
        this.queries = new LinkedHashMap<String, DataSetQuery>();
        this.previewAction = new PreviewAction();
        this.queryNameTextField = new JTextField(null, 0);
        this.queryNameTextField.setColumns(35);
        this.queryNameTextField.getDocument().addDocumentListener(new QueryNameTextFieldDocumentListener());
        this.queryTextArea = new JTextArea();
        this.queryTextArea.setRows(10);
        this.queryTextArea.setColumns(35);
        this.queryTextArea.getDocument().addDocumentListener(new QueryDocumentListener());
        this.queryNameList = new JList();
        this.queryNameList.setSelectionMode(0);
        this.queryNameList.setVisibleRowCount(5);
        this.queryNameList.addListSelectionListener(new QueryNameListSelectionListener());
        this.queryNameList.setCellRenderer(new QueryNameListCellRenderer());
        QueryRemoveAction removeQueryAction = new QueryRemoveAction();
        this.queryNameList.addListSelectionListener(removeQueryAction);
        super.init();
    }

    protected String getDialogId() {
        return "ReflectionDataSourceEditor";
    }

    protected Component createContentPane() {
        JPanel queryDetailsNamePanel = new JPanel(new BorderLayout());
        queryDetailsNamePanel.add((Component)new JLabel(messages.getString("ReflectionDataSourceEditor.QueryName")), "North");
        queryDetailsNamePanel.add((Component)this.queryNameTextField, "Center");
        JPanel queryContentHolder = new JPanel(new BorderLayout());
        queryContentHolder.add("North", new JLabel(messages.getString("ReflectionDataSourceEditor.QueryLabel")));
        queryContentHolder.add("Center", new JScrollPane(this.queryTextArea));
        JPanel queryDetailsPanel = new JPanel(new BorderLayout());
        queryDetailsPanel.setBorder(new EmptyBorder(0, 8, 8, 8));
        queryDetailsPanel.add("North", queryDetailsNamePanel);
        queryDetailsPanel.add("Center", queryContentHolder);
        JPanel previewButtonPanel = new JPanel(new FlowLayout(2));
        previewButtonPanel.add(new JButton(this.previewAction));
        JPanel previewPanel = new JPanel(new BorderLayout());
        previewPanel.add("South", previewButtonPanel);
        previewPanel.add("Center", queryDetailsPanel);
        JPanel queryContentPanel = new JPanel(new BorderLayout());
        queryContentPanel.add("North", this.createQueryListPanel());
        queryContentPanel.add("Center", previewPanel);
        return queryContentPanel;
    }

    private JPanel createQueryListPanel() {
        QueryRemoveAction queryRemoveAction = new QueryRemoveAction();
        this.queryNameList.addListSelectionListener(queryRemoveAction);
        JPanel theQueryButtonsPanel = new JPanel(new FlowLayout(2));
        theQueryButtonsPanel.add((Component)new BorderlessButton((Action)new QueryAddAction()));
        theQueryButtonsPanel.add((Component)new BorderlessButton((Action)queryRemoveAction));
        JPanel theQueryControlsPanel = new JPanel(new BorderLayout());
        theQueryControlsPanel.add((Component)new JLabel(messages.getString("ReflectionDataSourceEditor.AvailableQueries")), "West");
        theQueryControlsPanel.add((Component)theQueryButtonsPanel, "East");
        JPanel queryListPanel = new JPanel(new BorderLayout());
        queryListPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        queryListPanel.add("North", theQueryControlsPanel);
        queryListPanel.add("Center", new JScrollPane(this.queryNameList));
        return queryListPanel;
    }

    public NamedStaticDataFactory performConfiguration(NamedStaticDataFactory dataFactory, String selectedQuery) {
        this.queries.clear();
        if (dataFactory != null) {
            String[] queryNames = dataFactory.getQueryNames();
            for (int i = 0; i < queryNames.length; ++i) {
                String queryName = queryNames[i];
                String query = dataFactory.getQuery(queryName);
                this.queries.put(queryName, new DataSetQuery(queryName, query));
            }
        }
        this.updateComponents();
        this.updateQueryList();
        this.setSelectedQuery(selectedQuery);
        if (!this.performEdit()) {
            return null;
        }
        return this.produceFactory();
    }

    private NamedStaticDataFactory produceFactory() {
        NamedStaticDataFactory returnDataFactory = new NamedStaticDataFactory();
        DataSetQuery[] queries = this.queries.values().toArray(new DataSetQuery[this.queries.size()]);
        for (int i = 0; i < queries.length; ++i) {
            DataSetQuery query = queries[i];
            returnDataFactory.setQuery(query.getQueryName(), query.getQuery());
        }
        return returnDataFactory;
    }

    protected void updateQueryList() {
        this.queryNameList.removeAll();
        this.queryNameList.setListData(this.queries.values().toArray(new DataSetQuery[this.queries.size()]));
    }

    private void setSelectedQuery(String aQuery) {
        ListModel theModel = this.queryNameList.getModel();
        for (int i = 0; i < theModel.getSize(); ++i) {
            DataSetQuery theDataSet = (DataSetQuery)theModel.getElementAt(i);
            if (!theDataSet.getQueryName().equals(aQuery)) continue;
            this.queryNameList.setSelectedValue(theDataSet, true);
            break;
        }
    }

    protected void updateComponents() {
        boolean querySelected = this.queryNameList.getSelectedIndex() != -1;
        boolean hasQueries = this.queryNameList.getModel().getSize() > 0;
        this.queryNameTextField.setEnabled(querySelected);
        this.queryTextArea.setEnabled(querySelected);
        this.getConfirmAction().setEnabled(hasQueries);
        this.previewAction.setEnabled(querySelected);
    }

    private class PreviewAction
    extends AbstractAction {
        private PreviewAction() {
            this.putValue("Name", Messages.getString("ReflectionDataSourceEditor.Preview.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent aEvt) {
            try {
                String query = ReflectionDataSourceEditor.this.queryTextArea.getText();
                DataPreviewDialog previewDialog = new DataPreviewDialog((Dialog)((Object)ReflectionDataSourceEditor.this));
                ReflectionPreviewWorker worker = new ReflectionPreviewWorker(query);
                previewDialog.showData((PreviewWorker)worker);
                ReportDataFactoryException factoryException = worker.getException();
                if (factoryException != null) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)ReflectionDataSourceEditor.this), (String)Messages.getString("ReflectionDataSourceEditor.PreviewError.Title", new Object[0]), (String)Messages.getString("ReflectionDataSourceEditor.PreviewError.Message", new Object[0]), (Exception)((Object)factoryException));
                }
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Component)((Object)ReflectionDataSourceEditor.this), (String)Messages.getString("ReflectionDataSourceEditor.PreviewError.Title", new Object[0]), (String)Messages.getString("ReflectionDataSourceEditor.PreviewError.Message", new Object[0]), (Exception)e);
            }
        }
    }

    private class QueryDocumentListener
    implements DocumentListener {
        private QueryDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            DataSetQuery currentQuery = (DataSetQuery)ReflectionDataSourceEditor.this.queryNameList.getSelectedValue();
            if (currentQuery == null) {
                return;
            }
            currentQuery.setQuery(ReflectionDataSourceEditor.this.queryTextArea.getText());
        }
    }

    private class QueryAddAction
    extends AbstractAction {
        private QueryAddAction() {
            URL resource = ReflectionDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/reflection/resources/Add.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("ReflectionDataSourceEditor.AddQuery.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("ReflectionDataSourceEditor.AddQuery.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String queryName = Messages.getString("ReflectionDataSourceEditor.Query", new Object[0]);
            for (int i = 1; i < 1000; ++i) {
                String newQueryName = Messages.getString("ReflectionDataSourceEditor.Query", new Object[0]) + " " + i;
                if (ReflectionDataSourceEditor.this.queries.containsKey(newQueryName)) continue;
                queryName = newQueryName;
                break;
            }
            DataSetQuery newQuery = new DataSetQuery(queryName, "");
            ReflectionDataSourceEditor.this.queries.put(newQuery.getQueryName(), newQuery);
            ReflectionDataSourceEditor.this.inModifyingQueryNameList = true;
            ReflectionDataSourceEditor.this.updateQueryList();
            ReflectionDataSourceEditor.this.queryNameList.setSelectedValue(newQuery, true);
            ReflectionDataSourceEditor.this.inModifyingQueryNameList = false;
            ReflectionDataSourceEditor.this.updateComponents();
        }
    }

    private class QueryNameListSelectionListener
    implements ListSelectionListener {
        private QueryNameListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!ReflectionDataSourceEditor.this.inQueryNameUpdate) {
                DataSetQuery query = (DataSetQuery)ReflectionDataSourceEditor.this.queryNameList.getSelectedValue();
                if (query != null) {
                    ReflectionDataSourceEditor.this.queryNameTextField.setText(query.getQueryName());
                    ReflectionDataSourceEditor.this.queryTextArea.setText(query.getQuery());
                    ReflectionDataSourceEditor.this.updateComponents();
                } else {
                    ReflectionDataSourceEditor.this.queryNameTextField.setText("");
                    ReflectionDataSourceEditor.this.queryTextArea.setText("");
                    ReflectionDataSourceEditor.this.updateComponents();
                }
            }
        }
    }

    private static class QueryNameListCellRenderer
    extends DefaultListCellRenderer {
        private QueryNameListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel listCellRendererComponent = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                String queryName = ((DataSetQuery)value).getQueryName();
                if (!StringUtils.isEmpty((String)queryName)) {
                    listCellRendererComponent.setText(queryName);
                } else {
                    listCellRendererComponent.setText(" ");
                }
            }
            return listCellRendererComponent;
        }
    }

    private class QueryNameTextFieldDocumentListener
    implements DocumentListener {
        private QueryNameTextFieldDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            if (ReflectionDataSourceEditor.this.inModifyingQueryNameList) {
                return;
            }
            String queryName = ReflectionDataSourceEditor.this.queryNameTextField.getText();
            DataSetQuery currentQuery = (DataSetQuery)ReflectionDataSourceEditor.this.queryNameList.getSelectedValue();
            if (currentQuery == null) {
                return;
            }
            if (queryName.equals(currentQuery.getQueryName())) {
                return;
            }
            if (ReflectionDataSourceEditor.this.queries.containsKey(queryName)) {
                return;
            }
            ReflectionDataSourceEditor.this.inQueryNameUpdate = true;
            ReflectionDataSourceEditor.this.queries.remove(currentQuery.getQueryName());
            currentQuery.setQueryName(queryName);
            ReflectionDataSourceEditor.this.queries.put(currentQuery.getQueryName(), currentQuery);
            ReflectionDataSourceEditor.this.updateQueryList();
            ReflectionDataSourceEditor.this.queryNameList.setSelectedValue(currentQuery, true);
            ReflectionDataSourceEditor.this.inQueryNameUpdate = false;
        }
    }

    private class QueryRemoveAction
    extends AbstractAction
    implements ListSelectionListener {
        private QueryRemoveAction() {
            URL resource = ReflectionDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/reflection/resources/Remove.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("ReflectionDataSourceEditor.RemoveQuery.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("ReflectionDataSourceEditor.RemoveQuery.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataSetQuery query = (DataSetQuery)ReflectionDataSourceEditor.this.queryNameList.getSelectedValue();
            if (query != null) {
                ReflectionDataSourceEditor.this.queries.remove(query.getQueryName());
            }
            ReflectionDataSourceEditor.this.inModifyingQueryNameList = true;
            ReflectionDataSourceEditor.this.updateQueryList();
            ReflectionDataSourceEditor.this.queryNameList.clearSelection();
            ReflectionDataSourceEditor.this.inModifyingQueryNameList = false;
            ReflectionDataSourceEditor.this.updateComponents();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!ReflectionDataSourceEditor.this.queryNameList.isSelectionEmpty());
        }
    }
}

