/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import javax.persistence.QueryTimeoutException;
import javax.persistence.TransactionRequiredException;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.db.DatabaseRetryPredicate;

public class PersistenceExceptionSubclassFilterRetryPredicate
extends DatabaseRetryPredicate {
    private static final XLog LOG = XLog.getLog(PersistenceExceptionSubclassFilterRetryPredicate.class);
    private static final Set<Class<? extends PersistenceException>> BLACKLIST_WITH_CAUSE = Sets.newHashSet((Object[])new Class[]{EntityExistsException.class, EntityNotFoundException.class, LockTimeoutException.class, NoResultException.class, NonUniqueResultException.class, OptimisticLockException.class, PessimisticLockException.class, QueryTimeoutException.class, TransactionRequiredException.class});
    private static final Set<Class<? extends Exception>> BLACKLIST_WITHOUT_CAUSE = Sets.newHashSet((Object[])new Class[]{JPAExecutorException.class, RuntimeException.class});

    @Override
    public boolean apply(Throwable throwable) {
        LOG.trace("Retry predicate investigation started. [throwable.class={0}]", throwable.getClass().getName());
        boolean applies = true;
        if (throwable.getCause() == null && BLACKLIST_WITHOUT_CAUSE.contains(throwable.getClass())) {
            applies = false;
        } else {
            for (Class<?> classDownTheStackTrace : this.getAllExceptions(throwable)) {
                for (Class<? extends PersistenceException> blacklistElement : BLACKLIST_WITH_CAUSE) {
                    if (!blacklistElement.isAssignableFrom(classDownTheStackTrace)) continue;
                    applies = false;
                }
            }
        }
        LOG.trace("Retry predicate investigation finished. [applies={0}]", applies);
        return applies;
    }
}

