/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.report;

import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.BandTopLevelElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.report.PropertyArrayReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportGroupReadHandler
extends AbstractXmlReadHandler {
    private ReportGroupReadHandler groupReadHandler;
    private BandTopLevelElementReadHandler headerReadHandler;
    private BandTopLevelElementReadHandler footerReadHandler;
    private Group group;
    private PropertyReadHandler nameReadHandler;
    private PropertyArrayReadHandler groupFieldsReadHandler;

    public Group getGroup() {
        return this.group;
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("padding".equals(tagName)) {
            return new IgnoreAnyChildReadHandler();
        }
        if ("property".equals(tagName)) {
            String type = atts.getValue(uri, "name");
            if ("name".equals(type)) {
                this.nameReadHandler = new PropertyReadHandler();
                return this.nameReadHandler;
            }
            if ("groupFields".equals(type)) {
                this.groupFieldsReadHandler = new PropertyArrayReadHandler(String.class);
                return this.groupFieldsReadHandler;
            }
            return new IgnoreAnyChildReadHandler();
        }
        if ("child".equals(tagName)) {
            String type = atts.getValue(uri, "type");
            if ("org.pentaho.reportdesigner.crm.report.model.ReportGroup".equals(type)) {
                this.groupReadHandler = new ReportGroupReadHandler();
                return this.groupReadHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.BandToplevelGroupReportElement".equals(type)) {
                String bandtype = atts.getValue(uri, "bandToplevelType");
                if ("GROUP_FOOTER".equals(bandtype)) {
                    this.footerReadHandler = new BandTopLevelElementReadHandler((Band)new GroupFooter(), bandtype);
                    return this.footerReadHandler;
                }
                if ("GROUP_HEADER".equals(bandtype)) {
                    this.headerReadHandler = new BandTopLevelElementReadHandler((Band)new GroupHeader(), bandtype);
                    return this.headerReadHandler;
                }
            }
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        RelationalGroup group = new RelationalGroup();
        if (this.nameReadHandler != null) {
            group.setName(this.nameReadHandler.getResult());
        }
        if (this.groupFieldsReadHandler != null) {
            Object[] data = (Object[])this.groupFieldsReadHandler.getObject();
            String[] realValue = new String[data.length];
            System.arraycopy(data, 0, realValue, 0, data.length);
            group.setFieldsArray(realValue);
        }
        if (this.headerReadHandler != null) {
            group.setHeader((GroupHeader)this.headerReadHandler.getBand());
        }
        if (this.footerReadHandler != null) {
            group.setFooter((GroupFooter)this.footerReadHandler.getBand());
        }
        if (this.groupReadHandler != null) {
            SubGroupBody subGroupBody = new SubGroupBody();
            subGroupBody.setGroup(this.groupReadHandler.getGroup());
            group.setBody((GroupBody)subGroupBody);
        } else {
            group.setBody((GroupBody)new GroupDataBody());
        }
        this.group = group;
    }

    public Object getObject() throws SAXException {
        return this.group;
    }
}

