/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.PropertyStringReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.ObjectConverterFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class DesignerExpressionPropertyReadHandler
extends PropertyStringReadHandler {
    public static final String NAME_ATT = "name";
    public static final String CLASS_ATT = "class";
    private BeanUtility beanUtility;
    private String propertyName;
    private String propertyType;
    private String expressionName;
    private boolean array;
    private ArrayList arrayProperties;

    public DesignerExpressionPropertyReadHandler(BeanUtility expression, String expressionName) {
        if (expression == null) {
            throw new NullPointerException();
        }
        this.arrayProperties = new ArrayList();
        this.expressionName = expressionName;
        this.beanUtility = expression;
    }

    public void startParsing(PropertyAttributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.propertyType = CompatibilityMapperUtil.mapClassName((String)attrs.getValue(this.getUri(), CLASS_ATT));
        this.propertyName = attrs.getValue(this.getUri(), NAME_ATT);
        if (this.propertyName == null) {
            throw new ParseException("Required attribute 'name' is null.", this.getLocator());
        }
        String value = attrs.getValue(this.getUri(), "array");
        if (value != null) {
            this.array = true;
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes attrs) throws SAXException {
        if (!this.array) {
            return null;
        }
        if (this.isSameNamespace(uri) && "property".equals(tagName)) {
            PropertyReadHandler readHandler = new PropertyReadHandler();
            this.arrayProperties.add(readHandler);
            return readHandler;
        }
        return super.getHandlerForChild(uri, tagName, attrs);
    }

    public void doneParsing() throws SAXException {
        super.doneParsing();
        String result = this.getResult();
        if (this.beanUtility == null) {
            throw new ParseException("No current beanUtility", this.getLocator());
        }
        try {
            if (this.array) {
                Class type = this.beanUtility.getPropertyType(this.propertyName);
                HashMap<String, String> values = new HashMap<String, String>();
                int elementCount = this.arrayProperties.size();
                for (int i = 0; i < elementCount; ++i) {
                    PropertyReadHandler handler = (PropertyReadHandler)this.arrayProperties.get(i);
                    values.put(handler.getName(), handler.getResult());
                }
                Class<?> componentType = type.getComponentType();
                ArrayList<Object> realValues = new ArrayList<Object>();
                for (int i = 0; i < elementCount; ++i) {
                    String text = (String)values.get(String.valueOf(i));
                    if (text == null) {
                        throw new ParseException("Disrupted array - dont play games with me!", this.getLocator());
                    }
                    realValues.add(ObjectConverterFactory.convert(componentType, text, this.getLocator()));
                }
                Object[] o = (Object[])Array.newInstance(type.getComponentType(), realValues.size());
                Object[] objects = realValues.toArray(o);
                this.beanUtility.setProperty(this.propertyName, (Object)objects);
                return;
            }
            if (this.propertyType != null) {
                ClassLoader cl = ObjectUtilities.getClassLoader(DesignerExpressionPropertyReadHandler.class);
                Class<?> c = Class.forName(this.propertyType, false, cl);
                this.beanUtility.setPropertyAsString(this.propertyName, c, result);
            } else {
                this.beanUtility.setProperty(this.propertyName, ObjectConverterFactory.convert(this.beanUtility.getPropertyType(this.propertyName), result, this.getLocator()));
            }
        }
        catch (BeanException e) {
            if (this.isIgnorable()) {
                return;
            }
            throw new ParseException("Unable to assign property '" + this.propertyName + "' to expression '" + this.expressionName + '\'', (Exception)((Object)e), this.getLocator());
        }
        catch (ClassNotFoundException e) {
            if (this.isIgnorable()) {
                return;
            }
            throw new ParseException("Unable to assign property '" + this.propertyName + "' to expression '" + this.expressionName + '\'', (Exception)e, this.getLocator());
        }
    }

    public Object getObject() {
        return null;
    }

    public boolean isIgnorable() {
        if ("position".equals(this.propertyName)) {
            return true;
        }
        if ("minimumSize".equals(this.propertyName)) {
            return true;
        }
        if ("preferredSize".equals(this.propertyName)) {
            return true;
        }
        if ("maximumSize".equals(this.propertyName)) {
            return true;
        }
        if ("background".equals(this.propertyName)) {
            return true;
        }
        return "dynamicContent".equals(this.propertyName);
    }
}

