/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulRadio;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.SwingElement;
import org.pentaho.ui.xul.swing.SwingRoot;

public class SwingRadio
extends SwingElement
implements XulRadio {
    private String value;
    private String group;
    private JRadioButton radioButton = new JRadioButton();
    private static final Log logger = LogFactory.getLog(SwingRadio.class);

    public SwingRadio(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("radio");
        this.setManagedObject(this.radioButton);
        this.radioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                logger.debug((Object)("firing selected property change: isSelected=" + selected));
                SwingRadio.this.changeSupport.firePropertyChange("selected", null, (Object)selected);
            }
        });
    }

    public boolean isSelected() {
        return this.radioButton.isSelected();
    }

    public void setSelected(boolean selected) {
        this.radioButton.setSelected(selected);
    }

    @Override
    public void layout() {
    }

    public void setLabel(String label) {
        this.radioButton.setText(label);
    }

    public String getLabel() {
        return this.radioButton.getText();
    }

    @Override
    public boolean isDisabled() {
        return !this.radioButton.isEnabled();
    }

    @Override
    public void setDisabled(boolean dis) {
        this.radioButton.setEnabled(!dis);
    }

    public void setCommand(final String method) {
        this.radioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SwingRadio.this.invoke(method);
            }
        });
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String aValue) {
        String previousVal = this.value;
        this.value = aValue;
        this.changeSupport.firePropertyChange("value", previousVal, aValue);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void onDomReady() {
        if (this.group != null && this.getDocument() != null && this.getDocument().getRootElement() instanceof SwingRoot) {
            ButtonGroup buttonGroup = ((SwingRoot)this.getDocument().getRootElement()).getButtonGroup(this.group);
            AbstractButton button = (AbstractButton)this.getManagedObject();
            buttonGroup.add(button);
            if (buttonGroup.getButtonCount() == 1) {
                button.setSelected(true);
            }
        }
    }
}

