/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.SwingElement;

public class SwingCheckbox
extends SwingElement
implements XulCheckbox {
    private JCheckBox checkBox = new JCheckBox();
    private static final Log logger = LogFactory.getLog(SwingCheckbox.class);
    private String oncommand;
    private boolean initialized = false;

    public SwingCheckbox(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("checkbox");
        this.checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SwingCheckbox.this.changeSupport.firePropertyChange("checked", null, (Object)((JCheckBox)e.getSource()).isSelected());
            }
        });
        this.setManagedObject(this.checkBox);
    }

    public boolean getSelected() {
        return this.checkBox.isSelected();
    }

    public void setSelected(boolean selected) {
        this.checkBox.setSelected(selected);
    }

    @Override
    public void layout() {
        this.initialized = true;
    }

    public void setLabel(String label) {
        this.checkBox.setText(label);
    }

    public String getLabel() {
        return this.checkBox.getText();
    }

    public boolean isChecked() {
        return this.checkBox.isSelected();
    }

    @Override
    public boolean isDisabled() {
        return !this.checkBox.isEnabled();
    }

    public void setChecked(boolean checked) {
        this.checkBox.setSelected(checked);
    }

    @Override
    public void setDisabled(boolean dis) {
        this.checkBox.setEnabled(!dis);
    }

    public void setCommand(final String method) {
        this.oncommand = method;
        this.checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (SwingCheckbox.this.initialized) {
                    SwingCheckbox.this.invoke(method);
                }
            }
        });
    }

    public String getCommand() {
        return this.oncommand;
    }
}

