/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca;

import com.googlecode.jsendnsca.MessagePayload;
import com.googlecode.jsendnsca.NagiosException;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.PassiveCheckBytesBuilder;
import com.googlecode.jsendnsca.PassiveCheckSender;
import com.googlecode.jsendnsca.utils.IOUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.commons.lang.Validate;

public class NagiosPassiveCheckSender
implements PassiveCheckSender {
    private static final int INITIALISATION_VECTOR_SIZE = 128;
    private final NagiosSettings nagiosSettings;

    public NagiosPassiveCheckSender(NagiosSettings nagiosSettings) {
        Validate.notNull((Object)nagiosSettings, (String)"nagiosSettings cannot be null");
        this.nagiosSettings = nagiosSettings;
    }

    public void send(MessagePayload payload) throws NagiosException, IOException {
        Validate.notNull((Object)payload, (String)"payload cannot be null");
        Socket socket = new Socket();
        InetSocketAddress nagiosEndpoint = new InetSocketAddress(this.nagiosSettings.getNagiosHost(), this.nagiosSettings.getPort());
        OutputStream outputStream = null;
        DataInputStream inputStream = null;
        this.connectWithTimeout(socket, nagiosEndpoint);
        outputStream = socket.getOutputStream();
        inputStream = new DataInputStream(socket.getInputStream());
        byte[] initVector = this.readInitializationVector(inputStream);
        int timeStamp = inputStream.readInt();
        try {
            byte[] passiveCheckBytes = new PassiveCheckBytesBuilder().withTimeStamp(timeStamp).withLevel(payload.getLevel()).withHostname(payload.getHostname()).withServiceName(payload.getServiceName()).withMessage(payload.getMessage()).writeCRC().encrypt(initVector, this.nagiosSettings).toByteArray();
            outputStream.write(passiveCheckBytes);
            outputStream.flush();
        }
        catch (SocketTimeoutException ste) {
            throw ste;
        }
        catch (Exception e) {
            throw new NagiosException("Error occurred while sending passive alert", e);
        }
        finally {
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(socket);
        }
    }

    private void connectWithTimeout(Socket socket, InetSocketAddress nagiosEndpoint) throws IOException, SocketException {
        socket.connect(nagiosEndpoint, this.nagiosSettings.getConnectTimeout());
        socket.setSoTimeout(this.nagiosSettings.getTimeout());
    }

    private byte[] readInitializationVector(DataInputStream inputStream) throws NagiosException, SocketTimeoutException {
        byte[] initVector = new byte[128];
        try {
            inputStream.readFully(initVector, 0, 128);
            return initVector;
        }
        catch (SocketTimeoutException ste) {
            throw ste;
        }
        catch (Exception e) {
            throw new NagiosException("Can't read initialisation vector", e);
        }
    }
}

