/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.FSVisitor;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;

@InterfaceAudience.Private
public final class SnapshotReferenceUtil {
    public static final Log LOG = LogFactory.getLog(SnapshotReferenceUtil.class);

    private SnapshotReferenceUtil() {
    }

    public static Path getLogsDir(Path snapshotDir, String serverName) {
        return new Path(snapshotDir, DefaultWALProvider.getWALDirectoryName(serverName));
    }

    public static void visitReferencedFiles(Configuration conf, FileSystem fs, Path snapshotDir, SnapshotVisitor visitor) throws IOException {
        HBaseProtos.SnapshotDescription desc = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        SnapshotReferenceUtil.visitReferencedFiles(conf, fs, snapshotDir, desc, visitor);
    }

    public static void visitReferencedFiles(Configuration conf, FileSystem fs, Path snapshotDir, HBaseProtos.SnapshotDescription desc, SnapshotVisitor visitor) throws IOException {
        SnapshotReferenceUtil.visitTableStoreFiles(conf, fs, snapshotDir, desc, visitor);
        SnapshotReferenceUtil.visitLogFiles(fs, snapshotDir, visitor);
    }

    static void visitTableStoreFiles(Configuration conf, FileSystem fs, Path snapshotDir, HBaseProtos.SnapshotDescription desc, StoreFileVisitor visitor) throws IOException {
        SnapshotManifest manifest = SnapshotManifest.open(conf, fs, snapshotDir, desc);
        List<SnapshotProtos.SnapshotRegionManifest> regionManifests = manifest.getRegionManifests();
        if (regionManifests == null || regionManifests.size() == 0) {
            LOG.debug((Object)("No manifest files present: " + snapshotDir));
            return;
        }
        for (SnapshotProtos.SnapshotRegionManifest regionManifest : regionManifests) {
            SnapshotReferenceUtil.visitRegionStoreFiles(regionManifest, visitor);
        }
    }

    static void visitRegionStoreFiles(SnapshotProtos.SnapshotRegionManifest manifest, StoreFileVisitor visitor) throws IOException {
        HRegionInfo regionInfo = HRegionInfo.convert((HBaseProtos.RegionInfo)manifest.getRegionInfo());
        for (SnapshotProtos.SnapshotRegionManifest.FamilyFiles familyFiles : manifest.getFamilyFilesList()) {
            String familyName = familyFiles.getFamilyName().toStringUtf8();
            for (SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile : familyFiles.getStoreFilesList()) {
                visitor.storeFile(regionInfo, familyName, storeFile);
            }
        }
    }

    public static void visitLogFiles(FileSystem fs, Path snapshotDir, FSVisitor.LogFileVisitor visitor) throws IOException {
        FSVisitor.visitLogFiles(fs, snapshotDir, visitor);
    }

    public static void verifySnapshot(Configuration conf, FileSystem fs, Path snapshotDir, HBaseProtos.SnapshotDescription snapshotDesc) throws IOException {
        SnapshotManifest manifest = SnapshotManifest.open(conf, fs, snapshotDir, snapshotDesc);
        SnapshotReferenceUtil.verifySnapshot(conf, fs, manifest);
    }

    public static void verifySnapshot(final Configuration conf, final FileSystem fs, SnapshotManifest manifest) throws IOException {
        final HBaseProtos.SnapshotDescription snapshotDesc = manifest.getSnapshotDescription();
        final Path snapshotDir = manifest.getSnapshotDir();
        SnapshotReferenceUtil.concurrentVisitReferencedFiles(conf, fs, manifest, new StoreFileVisitor(){

            @Override
            public void storeFile(HRegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                SnapshotReferenceUtil.verifyStoreFile(conf, fs, snapshotDir, snapshotDesc, regionInfo, family, storeFile);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void concurrentVisitReferencedFiles(Configuration conf, FileSystem fs, SnapshotManifest manifest, final StoreFileVisitor visitor) throws IOException {
        HBaseProtos.SnapshotDescription snapshotDesc = manifest.getSnapshotDescription();
        Path snapshotDir = manifest.getSnapshotDir();
        List<SnapshotProtos.SnapshotRegionManifest> regionManifests = manifest.getRegionManifests();
        if (regionManifests == null || regionManifests.size() == 0) {
            LOG.debug((Object)("No manifest files present: " + snapshotDir));
            return;
        }
        ThreadPoolExecutor exec = SnapshotManifest.createExecutor(conf, "VerifySnapshot");
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(exec);
        try {
            for (final SnapshotProtos.SnapshotRegionManifest regionManifest : regionManifests) {
                completionService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws IOException {
                        SnapshotReferenceUtil.visitRegionStoreFiles(regionManifest, visitor);
                        return null;
                    }
                });
            }
            try {
                for (int i = 0; i < regionManifests.size(); ++i) {
                    completionService.take().get();
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof CorruptedSnapshotException) {
                    throw new CorruptedSnapshotException(e.getCause().getMessage(), snapshotDesc);
                }
                IOException ex = new IOException();
                ex.initCause(e.getCause());
                throw ex;
            }
        }
        finally {
            exec.shutdown();
        }
    }

    private static void verifyStoreFile(Configuration conf, FileSystem fs, Path snapshotDir, HBaseProtos.SnapshotDescription snapshot, HRegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
        TableName table = TableName.valueOf((String)snapshot.getTable());
        String fileName = storeFile.getName();
        Path refPath = null;
        if (StoreFileInfo.isReference(fileName)) {
            refPath = new Path(new Path(regionInfo.getEncodedName(), family), fileName);
            refPath = StoreFileInfo.getReferredToFile(refPath);
            String refRegion = refPath.getParent().getParent().getName();
            if (!HFileLink.buildFromHFileLinkPattern(conf, refPath = HFileLink.createPath(table, refRegion, family, refPath.getName())).exists(fs)) {
                throw new CorruptedSnapshotException("Missing parent hfile for: " + fileName + " path=" + refPath, snapshot);
            }
            if (storeFile.hasReference()) {
                return;
            }
        }
        Path linkPath = refPath != null && HFileLink.isHFileLink(refPath) ? new Path(family, refPath.getName()) : (HFileLink.isHFileLink(fileName) ? new Path(family, fileName) : new Path(family, HFileLink.createHFileLinkName(table, regionInfo.getEncodedName(), fileName)));
        HFileLink link = null;
        link = MobUtils.isMobRegionInfo(regionInfo) ? HFileLink.buildFromHFileLinkPattern(MobUtils.getQualifiedMobRootDir(conf), HFileArchiveUtil.getArchivePath(conf), linkPath) : HFileLink.buildFromHFileLinkPattern(conf, linkPath);
        try {
            FileStatus fstat = link.getFileStatus(fs);
            if (storeFile.hasFileSize() && storeFile.getFileSize() != fstat.getLen()) {
                String msg = "hfile: " + fileName + " size does not match with the expected one. " + " found=" + fstat.getLen() + " expected=" + storeFile.getFileSize();
                LOG.error((Object)msg);
                throw new CorruptedSnapshotException(msg, snapshot);
            }
        }
        catch (FileNotFoundException e) {
            String msg = "Can't find hfile: " + fileName + " in the real (" + link.getOriginPath() + ") or archive (" + link.getArchivePath() + ") directory for the primary table.";
            LOG.error((Object)msg);
            throw new CorruptedSnapshotException(msg, snapshot);
        }
    }

    public static Set<String> getHFileNames(Configuration conf, FileSystem fs, Path snapshotDir) throws IOException {
        HBaseProtos.SnapshotDescription desc = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        return SnapshotReferenceUtil.getHFileNames(conf, fs, snapshotDir, desc);
    }

    private static Set<String> getHFileNames(Configuration conf, FileSystem fs, Path snapshotDir, HBaseProtos.SnapshotDescription snapshotDesc) throws IOException {
        final HashSet<String> names = new HashSet<String>();
        SnapshotReferenceUtil.visitTableStoreFiles(conf, fs, snapshotDir, snapshotDesc, new StoreFileVisitor(){

            @Override
            public void storeFile(HRegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                String hfile = storeFile.getName();
                if (HFileLink.isHFileLink(hfile)) {
                    names.add(HFileLink.getReferencedHFileName(hfile));
                } else {
                    names.add(hfile);
                }
            }
        });
        return names;
    }

    public static Set<String> getWALNames(FileSystem fs, Path snapshotDir) throws IOException {
        final HashSet<String> names = new HashSet<String>();
        SnapshotReferenceUtil.visitLogFiles(fs, snapshotDir, new FSVisitor.LogFileVisitor(){

            @Override
            public void logFile(String server, String logfile) throws IOException {
                names.add(logfile);
            }
        });
        return names;
    }

    public static interface SnapshotVisitor
    extends StoreFileVisitor,
    FSVisitor.LogFileVisitor {
    }

    public static interface StoreFileVisitor {
        public void storeFile(HRegionInfo var1, String var2, SnapshotProtos.SnapshotRegionManifest.StoreFile var3) throws IOException;
    }
}

