/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.compactions.ExploringCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;

@InterfaceAudience.Private
public class CompactionConfiguration {
    static final Log LOG = LogFactory.getLog(CompactionConfiguration.class);
    public static final String HBASE_HSTORE_COMPACTION_RATIO_KEY = "hbase.hstore.compaction.ratio";
    public static final String HBASE_HSTORE_COMPACTION_RATIO_OFFPEAK_KEY = "hbase.hstore.compaction.ratio.offpeak";
    public static final String HBASE_HSTORE_COMPACTION_MIN_KEY = "hbase.hstore.compaction.min";
    public static final String HBASE_HSTORE_COMPACTION_MIN_SIZE_KEY = "hbase.hstore.compaction.min.size";
    public static final String HBASE_HSTORE_COMPACTION_MAX_KEY = "hbase.hstore.compaction.max";
    public static final String HBASE_HSTORE_COMPACTION_MAX_SIZE_KEY = "hbase.hstore.compaction.max.size";
    public static final String HBASE_HSTORE_OFFPEAK_END_HOUR = "hbase.offpeak.end.hour";
    public static final String HBASE_HSTORE_OFFPEAK_START_HOUR = "hbase.offpeak.start.hour";
    public static final String HBASE_HSTORE_MIN_LOCALITY_TO_SKIP_MAJOR_COMPACT = "hbase.hstore.min.locality.to.skip.major.compact";
    public static final String MAX_AGE_MILLIS_KEY = "hbase.hstore.compaction.date.tiered.max.storefile.age.millis";
    public static final String BASE_WINDOW_MILLIS_KEY = "hbase.hstore.compaction.date.tiered.base.window.millis";
    public static final String WINDOWS_PER_TIER_KEY = "hbase.hstore.compaction.date.tiered.windows.per.tier";
    public static final String INCOMING_WINDOW_MIN_KEY = "hbase.hstore.compaction.date.tiered.incoming.window.min";
    public static final String COMPACTION_POLICY_CLASS_FOR_TIERED_WINDOWS_KEY = "hbase.hstore.compaction.date.tiered.window.policy.class";
    public static final String SINGLE_OUTPUT_FOR_MINOR_COMPACTION_KEY = "hbase.hstore.compaction.date.tiered.single.output.for.minor.compaction";
    private static final Class<? extends RatioBasedCompactionPolicy> DEFAULT_TIER_COMPACTION_POLICY_CLASS = ExploringCompactionPolicy.class;
    Configuration conf;
    StoreConfigInformation storeConfigInfo;
    private final double offPeakCompactionRatio;
    private final long maxCompactSize;
    private final long minCompactSize;
    private int minFilesToCompact;
    private final int maxFilesToCompact;
    private final double compactionRatio;
    private final long throttlePoint;
    private final long majorCompactionPeriod;
    private final float majorCompactionJitter;
    private final float minLocalityToForceCompact;
    private final long maxStoreFileAgeMillis;
    private final long baseWindowMillis;
    private final int windowsPerTier;
    private final int incomingWindowMin;
    private final String compactionPolicyForTieredWindow;
    private final boolean singleOutputForMinorCompaction;

    CompactionConfiguration(Configuration conf, StoreConfigInformation storeConfigInfo) {
        this.conf = conf;
        this.storeConfigInfo = storeConfigInfo;
        this.maxCompactSize = conf.getLong(HBASE_HSTORE_COMPACTION_MAX_SIZE_KEY, Long.MAX_VALUE);
        this.minCompactSize = conf.getLong(HBASE_HSTORE_COMPACTION_MIN_SIZE_KEY, storeConfigInfo.getMemstoreFlushSize());
        this.minFilesToCompact = Math.max(2, conf.getInt(HBASE_HSTORE_COMPACTION_MIN_KEY, conf.getInt("hbase.hstore.compactionThreshold", 3)));
        this.maxFilesToCompact = conf.getInt(HBASE_HSTORE_COMPACTION_MAX_KEY, 10);
        this.compactionRatio = conf.getFloat(HBASE_HSTORE_COMPACTION_RATIO_KEY, 1.2f);
        this.offPeakCompactionRatio = conf.getFloat(HBASE_HSTORE_COMPACTION_RATIO_OFFPEAK_KEY, 5.0f);
        this.throttlePoint = conf.getLong("hbase.regionserver.thread.compaction.throttle", (long)(2 * this.maxFilesToCompact) * storeConfigInfo.getMemstoreFlushSize());
        this.majorCompactionPeriod = conf.getLong("hbase.hregion.majorcompaction", 604800000L);
        this.majorCompactionJitter = conf.getFloat("hbase.hregion.majorcompaction.jitter", 0.5f);
        this.minLocalityToForceCompact = conf.getFloat(HBASE_HSTORE_MIN_LOCALITY_TO_SKIP_MAJOR_COMPACT, 0.0f);
        this.maxStoreFileAgeMillis = conf.getLong(MAX_AGE_MILLIS_KEY, Long.MAX_VALUE);
        this.baseWindowMillis = conf.getLong(BASE_WINDOW_MILLIS_KEY, 21600000L);
        this.windowsPerTier = conf.getInt(WINDOWS_PER_TIER_KEY, 4);
        this.incomingWindowMin = conf.getInt(INCOMING_WINDOW_MIN_KEY, 6);
        this.compactionPolicyForTieredWindow = conf.get(COMPACTION_POLICY_CLASS_FOR_TIERED_WINDOWS_KEY, DEFAULT_TIER_COMPACTION_POLICY_CLASS.getName());
        this.singleOutputForMinorCompaction = conf.getBoolean(SINGLE_OUTPUT_FOR_MINOR_COMPACTION_KEY, true);
        LOG.info((Object)this);
    }

    public String toString() {
        return String.format("size [%d, %d); files [%d, %d); ratio %f; off-peak ratio %f; throttle point %d; major period %d, major jitter %f, min locality to compact %f; tiered compaction: max_age %d, base window in milliseconds %d, windows per tier %d,incoming window min %d", this.minCompactSize, this.maxCompactSize, this.minFilesToCompact, this.maxFilesToCompact, this.compactionRatio, this.offPeakCompactionRatio, this.throttlePoint, this.majorCompactionPeriod, Float.valueOf(this.majorCompactionJitter), Float.valueOf(this.minLocalityToForceCompact), this.maxStoreFileAgeMillis, this.baseWindowMillis, this.windowsPerTier, this.incomingWindowMin);
    }

    public long getMinCompactSize() {
        return this.minCompactSize;
    }

    public long getMaxCompactSize() {
        return this.maxCompactSize;
    }

    public int getMinFilesToCompact() {
        return this.minFilesToCompact;
    }

    public void setMinFilesToCompact(int threshold) {
        this.minFilesToCompact = threshold;
    }

    public int getMaxFilesToCompact() {
        return this.maxFilesToCompact;
    }

    public double getCompactionRatio() {
        return this.compactionRatio;
    }

    public double getCompactionRatioOffPeak() {
        return this.offPeakCompactionRatio;
    }

    public long getThrottlePoint() {
        return this.throttlePoint;
    }

    public long getMajorCompactionPeriod() {
        return this.majorCompactionPeriod;
    }

    public float getMajorCompactionJitter() {
        return this.majorCompactionJitter;
    }

    public float getMinLocalityToForceCompact() {
        return this.minLocalityToForceCompact;
    }

    public long getMaxStoreFileAgeMillis() {
        return this.maxStoreFileAgeMillis;
    }

    public long getBaseWindowMillis() {
        return this.baseWindowMillis;
    }

    public int getWindowsPerTier() {
        return this.windowsPerTier;
    }

    public int getIncomingWindowMin() {
        return this.incomingWindowMin;
    }

    public String getCompactionPolicyForTieredWindow() {
        return this.compactionPolicyForTieredWindow;
    }

    public boolean useSingleOutputForMinorCompaction() {
        return this.singleOutputForMinorCompaction;
    }
}

