/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.AbstractViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.BulkLoadCheckingViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.DisableTableViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.NoInsertsViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.NoWritesCompactionsViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.NoWritesViolationPolicyEnforcement;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;

public class SpaceViolationPolicyEnforcementFactory {
    private static final SpaceViolationPolicyEnforcementFactory INSTANCE = new SpaceViolationPolicyEnforcementFactory();

    private SpaceViolationPolicyEnforcementFactory() {
    }

    public static SpaceViolationPolicyEnforcementFactory getInstance() {
        return INSTANCE;
    }

    public SpaceViolationPolicyEnforcement create(RegionServerServices rss, TableName tableName, SpaceQuotaSnapshot snapshot) {
        AbstractViolationPolicyEnforcement enforcement;
        SpaceQuotaSnapshot.SpaceQuotaStatus status = snapshot.getQuotaStatus();
        if (!status.isInViolation()) {
            throw new IllegalArgumentException(tableName + " is not in violation. Snapshot=" + snapshot);
        }
        switch (status.getPolicy()) {
            case DISABLE: {
                enforcement = new DisableTableViolationPolicyEnforcement();
                break;
            }
            case NO_WRITES_COMPACTIONS: {
                enforcement = new NoWritesCompactionsViolationPolicyEnforcement();
                break;
            }
            case NO_WRITES: {
                enforcement = new NoWritesViolationPolicyEnforcement();
                break;
            }
            case NO_INSERTS: {
                enforcement = new NoInsertsViolationPolicyEnforcement();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled SpaceViolationPolicy: " + status.getPolicy());
            }
        }
        enforcement.initialize(rss, tableName, snapshot);
        return enforcement;
    }

    public SpaceViolationPolicyEnforcement createWithoutViolation(RegionServerServices rss, TableName tableName, SpaceQuotaSnapshot snapshot) {
        SpaceQuotaSnapshot.SpaceQuotaStatus status = snapshot.getQuotaStatus();
        if (status.isInViolation()) {
            throw new IllegalArgumentException(tableName + " is in violation. Logic error. Snapshot=" + snapshot);
        }
        BulkLoadCheckingViolationPolicyEnforcement enforcement = new BulkLoadCheckingViolationPolicyEnforcement();
        enforcement.initialize(rss, tableName, snapshot);
        return enforcement;
    }
}

