/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class MasterProcedureUtil {
    private static final Log LOG = LogFactory.getLog(MasterProcedureUtil.class);

    private MasterProcedureUtil() {
    }

    public static RPCProtos.UserInformation toProtoUserInfo(UserGroupInformation ugi) {
        RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
        userInfoPB.setEffectiveUser(ugi.getUserName());
        if (ugi.getRealUser() != null) {
            userInfoPB.setRealUser(ugi.getRealUser().getUserName());
        }
        return userInfoPB.build();
    }

    public static UserGroupInformation toUserInfo(RPCProtos.UserInformation userInfoProto) {
        if (userInfoProto.hasEffectiveUser()) {
            String effectiveUser = userInfoProto.getEffectiveUser();
            if (userInfoProto.hasRealUser()) {
                String realUser = userInfoProto.getRealUser();
                UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)realUser);
                return UserGroupInformation.createProxyUser((String)effectiveUser, (UserGroupInformation)realUserUgi);
            }
            return UserGroupInformation.createRemoteUser((String)effectiveUser);
        }
        return null;
    }

    public static HBaseProtos.ProcedureDescription buildProcedure(String signature, String instance, Map<String, String> props) {
        HBaseProtos.ProcedureDescription.Builder builder = HBaseProtos.ProcedureDescription.newBuilder();
        builder.setSignature(signature).setInstance(instance);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            HBaseProtos.NameStringPair pair = HBaseProtos.NameStringPair.newBuilder().setName(entry.getKey()).setValue(entry.getValue()).build();
            builder.addConfiguration(pair);
        }
        HBaseProtos.ProcedureDescription desc = builder.build();
        return desc;
    }

    public static long execProcedure(MasterProcedureManager mpm, String signature, String instance, Map<String, String> props) throws IOException {
        if (mpm == null) {
            throw new IOException("The procedure is not registered: " + signature);
        }
        HBaseProtos.ProcedureDescription desc = MasterProcedureUtil.buildProcedure(signature, instance, props);
        mpm.execProcedure(desc);
        long waitTime = 300000L;
        return waitTime;
    }

    public static void waitForProcedure(MasterProcedureManager mpm, String signature, String instance, Map<String, String> props, long max, int numRetries, long pause) throws IOException {
        HBaseProtos.ProcedureDescription desc = MasterProcedureUtil.buildProcedure(signature, instance, props);
        long start = EnvironmentEdgeManager.currentTime();
        long maxPauseTime = max / (long)numRetries;
        int tries = 0;
        LOG.debug((Object)("Waiting a max of " + max + " ms for procedure '" + signature + " : " + instance + "'' to complete. (max " + maxPauseTime + " ms per retry)"));
        boolean done = false;
        while (tries == 0 || EnvironmentEdgeManager.currentTime() - start < max && !done) {
            try {
                long sleep = HBaseAdmin.getPauseTime((int)tries++, (long)pause);
                sleep = sleep > maxPauseTime ? maxPauseTime : sleep;
                LOG.debug((Object)("(#" + tries + ") Sleeping: " + sleep + "ms while waiting for procedure completion."));
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
            LOG.debug((Object)"Getting current status of procedure from master...");
            done = mpm.isProcedureDone(desc);
        }
        if (!done) {
            throw new IOException("Procedure '" + signature + " : " + instance + "' wasn't completed in expectedTime:" + max + " ms");
        }
    }

    public static long submitProcedure(NonceProcedureRunnable runnable) throws IOException {
        ProcedureExecutor<MasterProcedureEnv> procExec = runnable.getProcedureExecutor();
        long procId = procExec.registerNonce(runnable.getNonceKey());
        if (procId >= 0L) {
            return procId;
        }
        try {
            runnable.run();
        }
        catch (IOException e) {
            procExec.setFailureResultForNonce(runnable.getNonceKey(), runnable.getDescription(), ((MasterProcedureEnv)procExec.getEnvironment()).getRequestUser(), e);
            throw e;
        }
        finally {
            procExec.unregisterNonceIfProcedureWasNotSubmitted(runnable.getNonceKey());
        }
        return runnable.getProcId();
    }

    public static abstract class NonceProcedureRunnable {
        private final MasterServices master;
        private final NonceKey nonceKey;
        private Long procId;

        public NonceProcedureRunnable(MasterServices master, long nonceGroup, long nonce) {
            this.master = master;
            this.nonceKey = this.getProcedureExecutor().createNonceKey(nonceGroup, nonce);
        }

        protected NonceKey getNonceKey() {
            return this.nonceKey;
        }

        protected MasterServices getMaster() {
            return this.master;
        }

        protected ProcedureExecutor<MasterProcedureEnv> getProcedureExecutor() {
            return this.master.getMasterProcedureExecutor();
        }

        protected long getProcId() {
            return this.procId != null ? this.procId : -1L;
        }

        protected long setProcId(long procId) {
            this.procId = procId;
            return procId;
        }

        protected abstract void run() throws IOException;

        protected abstract String getDescription();

        protected long submitProcedure(Procedure proc) {
            assert (this.procId == null) : "submitProcedure() was already called, running procId=" + this.procId;
            this.procId = this.getProcedureExecutor().submitProcedure(proc, this.nonceKey);
            return this.procId;
        }
    }
}

