/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupRestoreClientFactory;
import org.apache.hadoop.hbase.backup.RestoreClient;
import org.apache.hadoop.hbase.backup.util.BackupServerUtil;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.LogUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class RestoreDriver
extends AbstractHBaseTool {
    private static final Log LOG = LogFactory.getLog(RestoreDriver.class);
    private CommandLine cmd;
    private static final String OPTION_OVERWRITE = "overwrite";
    private static final String OPTION_CHECK = "check";
    private static final String OPTION_AUTOMATIC = "automatic";
    private static final String OPTION_SET = "set";
    private static final String OPTION_DEBUG = "debug";
    private static final String USAGE = "Usage: hbase restore [-set set_name] <backup_root_path> <backup_id> <tables> [tableMapping] \n       [-overwrite] [-check] [-automatic]\n backup_root_path  The parent location where the backup images are stored\n backup_id         The id identifying the backup image\n table(s)          Table(s) from the backup image to be restored.\n                   Tables are separated by comma.\n Options:\n   tableMapping    A comma separated list of target tables.\n                   If specified, each table in <tables> must have a mapping.\n   -overwrite      With this option, restore overwrites to the existing table if there's any in\n                   restore target. The existing table must be online before restore.\n   -check          With this option, restore sequence and dependencies are checked\n                   and verified without executing the restore\n   -set set_name   Backup set to restore, mutually exclusive with table list <tables>.";

    protected RestoreDriver() throws IOException {
        this.init();
    }

    protected void init() throws IOException {
        this.addOptNoArg(OPTION_OVERWRITE, "Overwrite the data if any of the restore target tables exists");
        this.addOptNoArg(OPTION_CHECK, "Check restore sequence and dependencies");
        this.addOptNoArg(OPTION_AUTOMATIC, "Restore all dependencies");
        this.addOptNoArg(OPTION_DEBUG, "Enable debug logging");
        this.addOptWithArg(OPTION_SET, "Backup set name");
        LogUtils.disableUselessLoggers(LOG);
    }

    private int parseAndRun(String[] args) {
        boolean check;
        boolean isOverwrite;
        Logger backupClientLogger = Logger.getLogger((String)"org.apache.hadoop.hbase.backup");
        if (this.cmd.hasOption(OPTION_DEBUG)) {
            backupClientLogger.setLevel(Level.DEBUG);
        }
        if (isOverwrite = this.cmd.hasOption(OPTION_OVERWRITE)) {
            LOG.debug((Object)"Found -overwrite option in restore command, will overwrite to existing table if any in the restore target");
        }
        if (check = this.cmd.hasOption(OPTION_CHECK)) {
            LOG.debug((Object)"Found -check option in restore command, will check and verify the dependencies");
        }
        LOG.debug((Object)"Will automatically restore all the dependencies");
        String[] remainArgs = this.cmd.getArgs();
        if (remainArgs.length < 3 && !this.cmd.hasOption(OPTION_SET) || this.cmd.hasOption(OPTION_SET) && remainArgs.length < 2) {
            System.out.println("ERROR: remain args length=" + remainArgs.length);
            System.out.println(USAGE);
            return -1;
        }
        String backupRootDir = remainArgs[0];
        String backupId = remainArgs[1];
        String tables = null;
        String tableMapping = null;
        if (this.cmd.hasOption(OPTION_SET)) {
            String setName = this.cmd.getOptionValue(OPTION_SET);
            try {
                tables = this.getTablesForSet(setName, this.conf);
            }
            catch (IOException e) {
                System.out.println("ERROR: " + e.getMessage() + " for setName=" + setName);
                return -2;
            }
            if (tables == null) {
                System.out.println("ERROR: Backup set '" + setName + "' is either empty or does not exist");
                return -3;
            }
            tableMapping = remainArgs.length > 2 ? remainArgs[2] : null;
        } else {
            tables = remainArgs[2];
            tableMapping = remainArgs.length > 3 ? remainArgs[3] : null;
        }
        TableName[] sTableArray = BackupServerUtil.parseTableNames(tables);
        TableName[] tTableArray = BackupServerUtil.parseTableNames(tableMapping);
        if (sTableArray != null && tTableArray != null && sTableArray.length != tTableArray.length) {
            System.out.println("ERROR: table mapping mismatch: " + tables + " : " + tableMapping);
            System.out.println(USAGE);
            return -4;
        }
        RestoreClient client = BackupRestoreClientFactory.getRestoreClient((Configuration)this.getConf());
        try {
            client.restore(backupRootDir, backupId, check, sTableArray, tTableArray, isOverwrite);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -5;
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    private String getTablesForSet(String name, Configuration conf) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void addOptions() {
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        this.cmd = cmd;
    }

    @Override
    protected int doWork() throws Exception {
        return this.parseAndRun(this.cmd.getArgs());
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new RestoreDriver(), (String[])args);
        System.exit(ret);
    }
}

