/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www.cache;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDate;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.pentaho.di.core.Const;
import org.pentaho.di.www.cache.CachedItem;

public class CarteStatusCache
implements Cache {
    public static final String CARTE_STATUS_CACHE = "CARTE_CACHE";
    private final ScheduledExecutorService removeService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            t.setName(CarteStatusCache.class.getSimpleName());
            return t;
        }
    });
    private final Map<String, CachedItem> cachedMap = new ConcurrentHashMap<String, CachedItem>();
    private static CarteStatusCache instance = null;
    private int period = Integer.parseInt(Const.getEnvironmentVariable((String)"CARTE_CLEAR_PERIOD", (String)"1"));
    private TimeUnit timeUnit = TimeUnit.valueOf(Const.getEnvironmentVariable((String)"CARTE_CLEAR_TIMEUNIT", (String)"DAYS"));

    public static synchronized CarteStatusCache getInstance() {
        if (instance == null) {
            instance = new CarteStatusCache();
        }
        return instance;
    }

    private CarteStatusCache() {
        this.removeService.scheduleAtFixedRate(this::clear, 1L, 1L, TimeUnit.DAYS);
    }

    public void put(String logId, String cacheString, int from) {
        block3: {
            String randomPref = UUID.randomUUID().toString();
            File file = null;
            try {
                file = File.createTempFile(randomPref, null);
                file.deleteOnExit();
                Files.write(file.toPath(), cacheString.getBytes("UTF-8"), new OpenOption[0]);
                CachedItem item = new CachedItem(file, from);
                item = this.cachedMap.put(logId, item);
                if (item != null) {
                    this.removeTask(item.getFile());
                }
            }
            catch (Exception e) {
                this.cachedMap.remove(logId);
                if (file == null) break block3;
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(String logId, int from) {
        CachedItem item = null;
        try {
            item = this.cachedMap.get(logId);
            if (item == null || item.getFrom() != from) {
                return null;
            }
            File file = item.getFile();
            synchronized (file) {
                return Files.readAllBytes(item.getFile().toPath());
            }
        }
        catch (Exception e) {
            this.cachedMap.remove(logId);
            if (item != null) {
                this.removeTask(item.getFile());
            }
            return null;
        }
    }

    public void remove(String id) {
        CachedItem item = this.cachedMap.remove(id);
        if (item != null) {
            this.removeTask(item.getFile());
        }
    }

    private void removeTask(File file) {
        this.removeService.execute(() -> this.removeFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFile(File file) {
        File file2 = file;
        synchronized (file2) {
            if (file.exists()) {
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    @VisibleForTesting
    Map<String, CachedItem> getMap() {
        return this.cachedMap;
    }

    public Object read(Object key) throws CacheException {
        return this.cachedMap.get(key);
    }

    public Object get(Object key) throws CacheException {
        return this.cachedMap.get(key);
    }

    public void put(Object key, Object value) throws CacheException {
        this.cachedMap.put((String)key, (CachedItem)value);
    }

    public void update(Object key, Object value) throws CacheException {
        this.put((String)key, (CachedItem)value);
    }

    public void remove(Object key) throws CacheException {
        this.remove((String)key);
    }

    public void clear() throws CacheException {
        this.cachedMap.forEach((k, v) -> {
            if (LocalDate.now().isAfter(v.getExceedTime())) {
                this.remove((String)k);
            }
        });
    }

    public void destroy() throws CacheException {
        this.clear();
    }

    public Map toMap() {
        return this.cachedMap;
    }

    public void lock(Object key) throws CacheException {
    }

    public void unlock(Object key) throws CacheException {
    }

    public long nextTimestamp() {
        return 0L;
    }

    public int getTimeout() {
        return 0;
    }

    public String getRegionName() {
        return null;
    }

    public long getSizeInMemory() {
        return 0L;
    }

    public long getElementCountInMemory() {
        return 0L;
    }

    public long getElementCountOnDisk() {
        return 0L;
    }
}

