/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.www.SocketRepositoryEntry;

public class SocketRepository {
    private Map<Integer, SocketRepositoryEntry> socketMap;
    private LogChannelInterface log;

    public SocketRepository(LogChannelInterface log) {
        this.log = log;
        this.socketMap = new HashMap<Integer, SocketRepositoryEntry>();
    }

    private ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.setPerformancePreferences(1, 2, 3);
        serverSocket.setReuseAddress(true);
        try {
            serverSocket.bind(new InetSocketAddress(port));
        }
        catch (BindException e) {
            long totalWait = 0L;
            long startTime = System.currentTimeMillis();
            IOException ioException = null;
            this.log.logMinimal("Carte socket repository : Starting a retry loop to bind the server socket on port " + port + ".  We retry for 5 minutes until the socket clears in your operating system.");
            while (!serverSocket.isBound() && totalWait < 300000L) {
                try {
                    totalWait = System.currentTimeMillis() - startTime;
                    this.log.logMinimal("Carte socket repository : Retry binding the server socket on port " + port + " after a " + totalWait / 1000L + " seconds wait...");
                    Thread.sleep(10000L);
                    serverSocket.bind(new InetSocketAddress(port), 100);
                }
                catch (IOException ioe) {
                    ioException = ioe;
                }
                catch (Exception ex) {
                    serverSocket.close();
                    throw new IOException(ex.getMessage());
                }
                totalWait = System.currentTimeMillis() - startTime;
            }
            if (!serverSocket.isBound()) {
                serverSocket.close();
                throw ioException;
            }
            this.log.logDetailed("Carte socket repository : Succesfully bound the server socket on port " + port + " after " + totalWait / 1000L + " seconds.");
        }
        return serverSocket;
    }

    public synchronized ServerSocket openServerSocket(int port, String user) throws IOException {
        SocketRepositoryEntry entry = this.socketMap.get(port);
        if (entry == null) {
            ServerSocket serverSocket = this.createServerSocket(port);
            entry = new SocketRepositoryEntry(port, serverSocket, true, user);
            this.socketMap.put(port, entry);
        } else {
            if (entry.isInUse()) {
                throw new IOException("Server socket on port " + port + " is already in use by [" + entry.getUser() + "]");
            }
            if (entry.getServerSocket().isClosed()) {
                entry.setServerSocket(this.createServerSocket(port));
            }
            entry.setInUse(true);
        }
        return entry.getServerSocket();
    }

    public synchronized void releaseSocket(int port) throws IOException {
        SocketRepositoryEntry entry = this.socketMap.get(port);
        if (entry == null) {
            throw new IOException("Port to close was not found in the Carte socket repository!");
        }
        entry.setInUse(false);
    }

    public Map<Integer, SocketRepositoryEntry> getSocketMap() {
        return this.socketMap;
    }

    public void setSocketMap(Map<Integer, SocketRepositoryEntry> socketMap) {
        this.socketMap = socketMap;
    }

    public synchronized void closeAll() {
        Iterator<Map.Entry<Integer, SocketRepositoryEntry>> iterator = this.socketMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, SocketRepositoryEntry> repositoryEntry = iterator.next();
            SocketRepositoryEntry entry = repositoryEntry.getValue();
            ServerSocket serverSocket = entry.getServerSocket();
            try {
                if (serverSocket == null) continue;
                serverSocket.close();
                iterator.remove();
            }
            catch (IOException e) {
                this.log.logError("Carte socket repository : Failed to close socket during shutdown", (Throwable)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.closeAll();
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }
}

