/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.symmetriccrypto.symmetriccryptotrans;

import org.apache.commons.codec.binary.Hex;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm.SymmetricCrypto;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetricalgorithm.SymmetricCryptoMeta;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetriccryptotrans.SymmetricCryptoTransData;
import org.pentaho.di.trans.steps.symmetriccrypto.symmetriccryptotrans.SymmetricCryptoTransMeta;

public class SymmetricCryptoTrans
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SymmetricCryptoTransMeta.class;
    private SymmetricCryptoTransMeta meta;
    private SymmetricCryptoTransData data;

    public SymmetricCryptoTrans(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block17: {
            Object realSecretKey;
            this.meta = (SymmetricCryptoTransMeta)smi;
            this.data = (SymmetricCryptoTransData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (Utils.isEmpty((CharSequence)this.meta.getResultfieldname())) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SymmetricCryptoTrans.Exception.ErrorResultFieldMissing", (String[])new String[0]));
                }
                if (Utils.isEmpty((CharSequence)this.meta.getMessageFied())) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SymmetricCryptoTrans.Exception.MissingMessageField", (String[])new String[0]));
                }
                this.data.indexOfMessage = this.getInputRowMeta().indexOfValue(this.meta.getMessageFied());
                if (this.data.indexOfMessage < 0) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"SymmetricCryptoTrans.Exception.CouldnotFindField", (String[])new String[]{this.meta.getMessageFied()}));
                }
                if (!this.meta.isSecretKeyInField()) {
                    realSecretKey = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.meta.getSecretKey()));
                    if (Utils.isEmpty((CharSequence)realSecretKey)) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"SymmetricCryptoTrans.Exception.SecretKeyMissing", (String[])new String[0]));
                    }
                    this.setSecretKey(realSecretKey);
                } else {
                    if (Utils.isEmpty((CharSequence)this.meta.getSecretKeyField())) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"SymmetricCryptoTrans.Exception.SecretKeyFieldMissing", (String[])new String[0]));
                    }
                    this.data.indexOfSecretkeyField = this.getInputRowMeta().indexOfValue(this.meta.getSecretKeyField());
                    if (this.data.indexOfSecretkeyField < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"SymmetricCryptoTrans.Exception.CouldnotFindField", (String[])new String[]{this.meta.getSecretKeyField()}));
                    }
                }
            }
            try {
                if (this.meta.isSecretKeyInField()) {
                    if (this.meta.isReadKeyAsBinary() ? (realSecretKey = this.getInputRowMeta().getBinary(r, this.data.indexOfSecretkeyField)) == null : Utils.isEmpty((CharSequence)((String)(realSecretKey = (Object)Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.getInputRowMeta().getString(r, this.data.indexOfSecretkeyField))))))) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"SymmetricCryptoTrans.Exception.SecretKeyMissing", (String[])new String[0]));
                    }
                    this.setSecretKey(realSecretKey);
                }
                Object result = null;
                if (this.meta.getOperationType() == 0) {
                    byte[] encrBytes = this.data.Crypt.encrDecryptData(this.getInputRowMeta().getBinary(r, this.data.indexOfMessage));
                    result = this.meta.isOutputResultAsBinary() ? encrBytes : (Object)new String(Hex.encodeHex((byte[])encrBytes));
                } else {
                    String s = this.getInputRowMeta().getString(r, this.data.indexOfMessage);
                    byte[] dataBytes = Hex.decodeHex((char[])s.toCharArray());
                    byte[] encrBytes = this.data.Crypt.encrDecryptData(dataBytes);
                    result = this.meta.isOutputResultAsBinary() ? encrBytes : (Object)new String(encrBytes);
                }
                Object[] outputRowData = RowDataUtil.addValueData((Object[])r, (int)this.getInputRowMeta().size(), (Object)result);
                this.putRow(this.data.outputRowMeta, outputRowData);
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"SymmetricCryptoTrans.Log.ErrorInStepRunning", (String[])new String[0]), e);
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                String errorMessage = e.toString();
                if (!sendToErrorRow) break block17;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "EncDecr001");
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SymmetricCryptoTransMeta)smi;
        this.data = (SymmetricCryptoTransData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.CryptMeta = new SymmetricCryptoMeta(this.meta.getAlgorithm());
                this.data.Crypt = new SymmetricCrypto(this.data.CryptMeta, this.environmentSubstitute(this.meta.getSchema()));
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"SymmetricCryptoTrans.ErrorInit.", (String[])new String[0]), e);
                return false;
            }
            return true;
        }
        return false;
    }

    private void setSecretKey(Object key) throws KettleException {
        if (key instanceof byte[]) {
            this.data.Crypt.setSecretKey((byte[])key);
        } else {
            this.data.Crypt.setSecretKey((String)key);
        }
        if (this.meta.getOperationType() == 0) {
            this.data.Crypt.setEncryptMode();
        } else {
            this.data.Crypt.setDecryptMode();
        }
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SymmetricCryptoTransMeta)smi;
        this.data = (SymmetricCryptoTransData)sdi;
        if (this.data.Crypt != null) {
            this.data.Crypt.close();
        }
        super.dispose(smi, sdi);
    }
}

