/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.randomccnumber;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.randomccnumber.RandomCCNumberGenerator;
import org.pentaho.di.trans.steps.randomccnumber.RandomCCNumberGeneratorData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class RandomCCNumberGeneratorMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = RandomCCNumberGeneratorMeta.class;
    private String[] fieldCCType;
    private String[] fieldCCLength;
    private String[] fieldCCSize;
    private String cardNumberFieldName;
    private String cardLengthFieldName;
    private String cardTypeFieldName;

    public String[] getFieldCCType() {
        return this.fieldCCType;
    }

    public String getCardNumberFieldName() {
        return this.cardNumberFieldName;
    }

    public void setCardNumberFieldName(String cardNumberFieldName) {
        this.cardNumberFieldName = cardNumberFieldName;
    }

    public String getCardLengthFieldName() {
        return this.cardLengthFieldName;
    }

    public void setCardLengthFieldName(String cardLengthFieldName) {
        this.cardLengthFieldName = cardLengthFieldName;
    }

    public String getCardTypeFieldName() {
        return this.cardTypeFieldName;
    }

    public void setCardTypeFieldName(String cardTypeFieldName) {
        this.cardTypeFieldName = cardTypeFieldName;
    }

    public void setFieldCCType(String[] fieldName) {
        this.fieldCCType = fieldName;
    }

    public String[] getFieldCCLength() {
        return this.fieldCCLength;
    }

    public String[] getFieldCCSize() {
        return this.fieldCCSize;
    }

    public void setFieldCCSize(String[] ccSize) {
        this.fieldCCSize = ccSize;
    }

    @Deprecated
    public void setFieldType(String[] fieldType) {
        this.fieldCCLength = fieldType;
    }

    public void setFieldCCLength(String[] ccLength) {
        this.fieldCCLength = ccLength;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.fieldCCType = new String[count];
        this.fieldCCLength = new String[count];
        this.fieldCCSize = new String[count];
    }

    @Override
    public Object clone() {
        RandomCCNumberGeneratorMeta retval = (RandomCCNumberGeneratorMeta)super.clone();
        int count = this.fieldCCType.length;
        retval.allocate(count);
        System.arraycopy(this.fieldCCType, 0, retval.fieldCCType, 0, count);
        System.arraycopy(this.fieldCCLength, 0, retval.fieldCCLength, 0, count);
        System.arraycopy(this.fieldCCSize, 0, retval.fieldCCSize, 0, count);
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldCCType[i] = XMLHandler.getTagValue((Node)fnode, (String)"cctype");
                this.fieldCCLength[i] = XMLHandler.getTagValue((Node)fnode, (String)"cclen");
                this.fieldCCSize[i] = XMLHandler.getTagValue((Node)fnode, (String)"ccsize");
            }
            this.cardNumberFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"cardNumberFieldName");
            this.cardLengthFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"cardLengthFieldName");
            this.cardTypeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"cardTypeFieldName");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read step information from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldCCType[i] = "field" + i;
            this.fieldCCLength[i] = "";
            this.fieldCCSize[i] = "";
        }
        this.cardNumberFieldName = BaseMessages.getString(PKG, (String)"RandomCCNumberGeneratorMeta.CardNumberField", (String[])new String[0]);
        this.cardLengthFieldName = BaseMessages.getString(PKG, (String)"RandomCCNumberGeneratorMeta.CardLengthField", (String[])new String[0]);
        this.cardTypeFieldName = BaseMessages.getString(PKG, (String)"RandomCCNumberGeneratorMeta.CardTypeField", (String[])new String[0]);
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaString v = new ValueMetaString(this.cardNumberFieldName);
        v.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)v);
        if (!Utils.isEmpty((CharSequence)this.getCardTypeFieldName())) {
            v = new ValueMetaString(this.cardTypeFieldName);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getCardLengthFieldName())) {
            v = new ValueMetaInteger(this.cardLengthFieldName);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(200);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldCCType.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"cctype", (String)this.fieldCCType[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"cclen", (String)this.fieldCCLength[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"ccsize", (String)this.fieldCCSize[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"cardNumberFieldName", (String)this.cardNumberFieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"cardLengthFieldName", (String)this.cardLengthFieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"cardTypeFieldName", (String)this.cardTypeFieldName));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "cctype");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldCCType[i] = rep.getStepAttributeString(id_step, i, "cctype");
                this.fieldCCLength[i] = rep.getStepAttributeString(id_step, i, "cclen");
                this.fieldCCSize[i] = rep.getStepAttributeString(id_step, i, "ccsize");
            }
            this.cardNumberFieldName = rep.getStepAttributeString(id_step, "cardNumberFieldName");
            this.cardLengthFieldName = rep.getStepAttributeString(id_step, "cardLengthFieldName");
            this.cardTypeFieldName = rep.getStepAttributeString(id_step, "cardTypeFieldName");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldCCType.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "cctype", this.fieldCCType[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "cclen", this.fieldCCLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "ccsize", this.fieldCCSize[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "cardNumberFieldName", this.cardNumberFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "cardLengthFieldName", this.cardLengthFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "cardTypeFieldName", this.cardTypeFieldName);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        int nrRemarks = remarks.size();
        for (int i = 0; i < this.fieldCCType.length; ++i) {
            int size;
            int len = Const.toInt((String)transMeta.environmentSubstitute(this.getFieldCCLength()[i]), (int)-1);
            if (len < 0) {
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RandomCCNumberGeneratorMeta.CheckResult.WrongLen", (String[])new String[]{String.valueOf(i)}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            if ((size = Const.toInt((String)transMeta.environmentSubstitute(this.getFieldCCSize()[i]), (int)-1)) >= 0) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RandomCCNumberGeneratorMeta.CheckResult.WrongSize", (String[])new String[]{String.valueOf(i)}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RandomCCNumberGeneratorMeta.CheckResult.AllTypesSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Utils.isEmpty((CharSequence)this.getCardNumberFieldName())) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RandomCCNumberGeneratorMeta.CheckResult.CardNumberFieldMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new RandomCCNumberGenerator(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new RandomCCNumberGeneratorData();
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        return new StepIOMeta(false, true, false, false, false, false);
    }
}

