/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.blockuntilstepsfinish;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.blockuntilstepsfinish.BlockUntilStepsFinishData;
import org.pentaho.di.trans.steps.blockuntilstepsfinish.BlockUntilStepsFinishMeta;

public class BlockUntilStepsFinish
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = BlockUntilStepsFinishMeta.class;
    private BlockUntilStepsFinishMeta meta;
    private BlockUntilStepsFinishData data;

    public BlockUntilStepsFinish(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (BlockUntilStepsFinishMeta)smi;
        this.data = (BlockUntilStepsFinishData)sdi;
        if (this.first) {
            this.first = false;
            String[] stepnames = null;
            int stepnrs = 0;
            if (this.meta.getStepName() == null || this.meta.getStepName().length <= 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"BlockUntilStepsFinish.Error.NotSteps", (String[])new String[0]));
            }
            stepnames = this.meta.getStepName();
            stepnrs = stepnames.length;
            String[] targetSteps = this.getTransMeta().getNextStepNames(this.getStepMeta());
            this.data.stepInterfaces = new ConcurrentHashMap();
            for (int i = 0; i < stepnrs; ++i) {
                if (stepnames[i].equals(this.getStepname())) {
                    throw new KettleException("You can not wait for step [" + stepnames[i] + "] to finish!");
                }
                if (targetSteps != null) {
                    for (int j = 0; j < targetSteps.length; ++j) {
                        if (!stepnames[i].equals(targetSteps[j])) continue;
                        throw new KettleException("You can not get metrics for the target step [" + targetSteps[j] + "]!");
                    }
                }
                int CopyNr = Const.toInt((String)this.meta.getStepCopyNr()[i], (int)0);
                StepInterface step = this.getDispatcher().findBaseSteps(stepnames[i]).get(CopyNr);
                if (step == null) {
                    throw new KettleException("Erreur finding step [" + stepnames[i] + "] nr copy=" + CopyNr + "!");
                }
                this.data.stepInterfaces.put(i, this.getDispatcher().findBaseSteps(stepnames[i]).get(CopyNr));
            }
        }
        while (this.data.continueLoop && !this.isStopped()) {
            this.data.continueLoop = false;
            for (Map.Entry<Integer, StepInterface> e : this.data.stepInterfaces.entrySet()) {
                StepInterface step = e.getValue();
                if (step.getStatus() != BaseStepData.StepExecutionStatus.STATUS_FINISHED) {
                    this.data.continueLoop = true;
                    continue;
                }
                this.data.stepInterfaces.remove(e.getKey());
                if (!this.log.isDetailed()) continue;
                this.logDetailed("Finished running step [" + step.getStepname() + "(" + step.getCopy() + ")].");
            }
            if (!this.data.continueLoop) continue;
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.putRow(this.getInputRowMeta(), r);
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (BlockUntilStepsFinishMeta)smi;
        this.data = (BlockUntilStepsFinishData)sdi;
        return super.init(smi, sdi);
    }
}

