/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.i18n.BaseMessages;

public final class PluginMessages {
    private static final ConcurrentHashMap<String, PluginMessages> MESSAGES_MAP = new ConcurrentHashMap();
    private final String packageName;

    public static PluginMessages getMessages(String packageName) throws IllegalArgumentException {
        Assert.assertNotBlank(packageName, "Package name cannot be blank");
        PluginMessages pm = MESSAGES_MAP.get(packageName);
        if (pm == null) {
            return MESSAGES_MAP.putIfAbsent(packageName, new PluginMessages(packageName));
        }
        return pm;
    }

    public static PluginMessages getMessages(Class<?> someClassInPackage) throws IllegalArgumentException {
        Assert.assertNotNull(someClassInPackage, "Class cannot be null");
        return PluginMessages.getMessages(someClassInPackage.getPackage().getName());
    }

    private PluginMessages(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getString(String key) {
        return BaseMessages.getString((String)this.packageName, (String)key);
    }

    public String getString(String key, String param1) {
        return BaseMessages.getString((String)this.packageName, (String)key, (String[])new String[]{param1});
    }

    public String getString(String key, String param1, String param2) {
        return BaseMessages.getString((String)this.packageName, (String)key, (String[])new String[]{param1, param2});
    }

    public String getString(String key, String param1, String param2, String param3) {
        return BaseMessages.getString((String)this.packageName, (String)key, (String[])new String[]{param1, param2, param3});
    }

    public String getString(String key, String param1, String param2, String param3, String param4) {
        return BaseMessages.getString((String)this.packageName, (String)key, (String[])new String[]{param1, param2, param3, param4});
    }

    public String getString(String key, String param1, String param2, String param3, String param4, String param5) {
        return BaseMessages.getString((String)this.packageName, (String)key, (String[])new String[]{param1, param2, param3, param4, param5});
    }

    public String getString(String key, String param1, String param2, String param3, String param4, String param5, String param6) {
        return BaseMessages.getString((String)this.packageName, (String)key, (String[])new String[]{param1, param2, param3, param4, param5, param6});
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("packageName", (Object)this.packageName);
        return builder.toString();
    }
}

