/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.validation;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.CheckStepsExtension;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.paramgen.ParameterGeneration;
import org.pentaho.di.trans.dataservice.validation.StepValidation;
import org.pentaho.di.trans.dataservice.validation.ValidationUtil;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;

public class TableInputValidation
implements StepValidation {
    private static Class<?> PKG = TableInputValidation.class;

    @Override
    public boolean supportsStep(StepMeta step, LogChannelInterface log) {
        return step.getStepMetaInterface() instanceof TableInputMeta;
    }

    @Override
    public void checkStep(CheckStepsExtension checkStepExtension, DataServiceMeta dataServiceMeta, LogChannelInterface log) {
        this.checkMissingDefinedParam(checkStepExtension, dataServiceMeta);
        this.checkPushdownParameter(checkStepExtension);
    }

    private void checkMissingDefinedParam(CheckStepsExtension checkStepExtension, DataServiceMeta dataServiceMeta) {
        StepMeta checkedStepMeta = checkStepExtension.getStepMetas()[0];
        TableInputMeta tableInputMeta = (TableInputMeta)checkedStepMeta.getStepMetaInterface();
        for (ParameterGeneration paramGen : ValidationUtil.getParameterGenerationsForStep(dataServiceMeta, checkedStepMeta.getName())) {
            if (!Const.isEmpty((String)tableInputMeta.getSQL()) && tableInputMeta.getSQL().contains(paramGen.getParameterName())) continue;
            checkStepExtension.getRemarks().add(ValidationUtil.warn(BaseMessages.getString(PKG, (String)"TableInputValidation.MissingDefinedParam.Message", (String[])new String[]{checkedStepMeta.getName(), paramGen.getParameterName()}), checkedStepMeta));
        }
    }

    private void checkPushdownParameter(CheckStepsExtension checkStepExtension) {
        StepMeta checkedStepMeta = checkStepExtension.getStepMetas()[0];
        TableInputMeta tableInputMeta = (TableInputMeta)checkedStepMeta.getStepMetaInterface();
        String sql = tableInputMeta.getSQL();
        if (Const.isEmpty((String)sql) || !ValidationUtil.paramSubstitutionModifiesString(sql, checkStepExtension.getVariableSpace())) {
            checkStepExtension.getRemarks().add(ValidationUtil.warn(BaseMessages.getString(PKG, (String)"TableInputValidation.NoParameters.Message", (String[])new String[]{checkedStepMeta.getName()}), checkedStepMeta));
        }
    }
}

