/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.serialization;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.serialization.DataServiceAlreadyExistsException;
import org.pentaho.di.trans.dataservice.serialization.DataServiceReferenceSynchronizer;

@ExtensionPoint(id="TransImportExtensionPointPlugin", extensionPointId="TransImportAfterSaveToRepo", description="Synchronize data services references in metastore after transformation is imported to repository")
public class TransImportExtensionPointPlugin
implements ExtensionPointInterface {
    private Class<TransImportExtensionPointPlugin> PKG = TransImportExtensionPointPlugin.class;
    private DataServiceReferenceSynchronizer referenceSynchronizer;

    public TransImportExtensionPointPlugin(DataServiceReferenceSynchronizer referenceSynchronizer) {
        this.referenceSynchronizer = referenceSynchronizer;
    }

    public void callExtensionPoint(LogChannelInterface log, Object o) throws KettleException {
        if (!(o instanceof TransMeta)) {
            return;
        }
        TransMeta transMeta = (TransMeta)o;
        this.referenceSynchronizer.sync(transMeta, this.getExceptionHandler(log), true);
    }

    Function<Exception, Void> getExceptionHandler(final LogChannelInterface log) {
        return new Function<Exception, Void>(){

            @Override
            @Nullable
            public Void apply(@Nullable Exception e) {
                if (e instanceof DataServiceAlreadyExistsException) {
                    DataServiceAlreadyExistsException dsaee = (DataServiceAlreadyExistsException)((Object)e);
                    log.logBasic(BaseMessages.getString((Class)TransImportExtensionPointPlugin.this.PKG, (String)"Messages.Import.Overwrite", (String[])new String[]{dsaee.getDataServiceMeta().getName()}));
                } else {
                    log.logError(BaseMessages.getString((Class)TransImportExtensionPointPlugin.this.PKG, (String)"Messages.Import.Error", (String[])new String[0]), (Throwable)e);
                }
                return null;
            }
        };
    }
}

