/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.serialization;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.List;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.serialization.DataServiceMetaStoreUtil;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public abstract class DataServiceFactory
extends DataServiceMetaStoreUtil {
    private static final Class<?> PKG = DataServiceFactory.class;
    protected static IMetaStore localPentahoMetaStore = DataServiceFactory.openLocalPentahoMetaStore();

    private static IMetaStore openLocalPentahoMetaStore() {
        try {
            return MetaStoreConst.openLocalPentahoMetaStore();
        }
        catch (MetaStoreException e) {
            LogChannel.GENERAL.logError(BaseMessages.getString(PKG, (String)"DataServiceFactory.LocalMetaStoreError", (String[])new String[0]), (Throwable)e);
            return null;
        }
    }

    protected DataServiceFactory(DataServiceContext context) {
        super(context.getMetaStoreUtil());
    }

    public abstract Repository getRepository();

    public IMetaStore getMetaStore() {
        Repository repository = this.getRepository();
        return (IMetaStore)Preconditions.checkNotNull((Object)(repository != null ? repository.getMetaStore() : localPentahoMetaStore), (Object)BaseMessages.getString(PKG, (String)"DataServiceFactory.NullMetaStore", (String[])new String[0]));
    }

    public DataServiceMeta getDataService(String serviceName) throws MetaStoreException {
        return this.getDataService(serviceName, this.getRepository(), this.getMetaStore());
    }

    public Iterable<DataServiceMeta> getDataServices(Function<Exception, Void> exceptionHandler) {
        return this.getDataServices(this.getRepository(), this.getMetaStore(), exceptionHandler);
    }

    public List<String> getDataServiceNames() throws MetaStoreException {
        return this.getDataServiceNames(this.getMetaStore());
    }

    public DataServiceExecutor.Builder createBuilder(SQL sql) throws MetaStoreException {
        DataServiceMeta dataService = this.getDataService(sql.getServiceName());
        if (dataService.isStreaming()) {
            return new DataServiceExecutor.Builder(sql, dataService, this.context).rowLimit(dataService.getRowLimit()).timeLimit(dataService.getTimeLimit());
        }
        return new DataServiceExecutor.Builder(sql, dataService, this.context);
    }
}

