/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;

public class CommandExecutor {
    public static final String COMMAND_START = "[";
    public static final String COMMAND_END = "]";
    private Map<String, Command> commands = new HashMap<String, Command>();
    private String func;
    private String[] args;

    private CommandExecutor(Builder builder) {
        this.func = builder.func;
        this.args = builder.args;
        this.commands.put("stop", new StopCommand(builder.context));
        this.commands.put("errors", new ErrorsCommand(builder.context));
    }

    public static String buildCommand(String command, String ... args) {
        StringBuilder builder = new StringBuilder();
        builder.append(COMMAND_START);
        builder.append(" ");
        builder.append(command);
        builder.append(" ");
        for (String arg : args) {
            builder.append(arg);
            builder.append(" ");
        }
        builder.append(COMMAND_END);
        return builder.toString();
    }

    public void execute(DataOutputStream dataOutputStream) throws IOException {
        Command command = this.commands.get(this.func);
        if (command != null) {
            String result = command.execute(this.args);
            dataOutputStream.writeUTF(result);
        }
    }

    public class ErrorsCommand
    extends ExecutorCommand {
        public static final String ERRORS = "errors";

        public ErrorsCommand(DataServiceContext context) {
            super(context);
        }

        @Override
        public String execute(String[] args) {
            DataServiceExecutor executor = this.context.getExecutor(args[0]);
            if (executor != null && executor.hasErrors().booleanValue()) {
                return "true";
            }
            return "false";
        }
    }

    public class StopCommand
    extends ExecutorCommand {
        public static final String STOP = "stop";

        public StopCommand(DataServiceContext context) {
            super(context);
        }

        @Override
        public String execute(String[] args) {
            DataServiceExecutor executor = this.context.getExecutor(args[0]);
            if (executor != null) {
                executor.stop(false);
                this.context.removeExecutor(args[0]);
                return "true";
            }
            return "false";
        }
    }

    private abstract class ExecutorCommand
    implements Command {
        protected final DataServiceContext context;

        private ExecutorCommand(DataServiceContext context) {
            this.context = context;
        }
    }

    private static interface Command {
        public String execute(String[] var1);
    }

    public static class Builder {
        private String command;
        private DataServiceContext context;
        private String func;
        private String[] args;

        public Builder(String command, DataServiceContext context) {
            this.command = command;
            this.context = context;
        }

        public CommandExecutor build() {
            String[] parts = this.command.substring(CommandExecutor.COMMAND_START.length(), this.command.length() - CommandExecutor.COMMAND_END.length()).trim().split(" ");
            this.func = parts[0];
            this.args = Arrays.copyOfRange(parts, 1, parts.length);
            return new CommandExecutor(this);
        }
    }
}

