/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.output;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.MappingAdmin;
import org.pentaho.big.data.kettle.plugins.hbase.output.HBaseOutputData;
import org.pentaho.big.data.kettle.plugins.hbase.output.HBaseOutputMeta;
import org.pentaho.big.data.kettle.plugins.hbase.output.KettleRowToHBaseTuple;
import org.pentaho.bigdata.api.hbase.ByteConversionUtil;
import org.pentaho.bigdata.api.hbase.HBaseConnection;
import org.pentaho.bigdata.api.hbase.HBaseService;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.bigdata.api.hbase.table.HBaseDelete;
import org.pentaho.bigdata.api.hbase.table.HBasePut;
import org.pentaho.bigdata.api.hbase.table.HBaseTable;
import org.pentaho.bigdata.api.hbase.table.HBaseTableWriteOperationManager;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class HBaseOutput
extends BaseStep
implements StepInterface {
    protected HBaseOutputMeta m_meta;
    protected HBaseOutputData m_data;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private HBaseService hBaseService;
    private HBaseTableWriteOperationManager targetTableWriteOperationManager;
    protected HBaseConnection m_hbAdmin;
    protected ByteConversionUtil m_bytesUtil;
    protected MappingAdmin m_mappingAdmin;
    protected Mapping m_tableMapping;
    protected Map<String, HBaseValueMetaInterface> m_columnsMappedByAlias;
    protected HBaseTable targetTable;
    protected int m_incomingKeyIndex;
    protected ValueMetaInterface m_incomingKeyValueMeta;
    protected KettleRowToHBaseTuple tupleRowConverter;

    public HBaseOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.namedClusterServiceLocator = namedClusterServiceLocator;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        String errorDescriptions;
        HBasePut hBasePut;
        String errorDescriptions2;
        Object[] r = this.getRow();
        if (r == null) {
            if (this.targetTable != null) {
                if (this.targetTableWriteOperationManager != null) {
                    try {
                        if (!this.targetTableWriteOperationManager.isAutoFlush()) {
                            this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.FlushingWriteBuffer", (String[])new String[0]));
                            this.targetTableWriteOperationManager.flushCommits();
                        }
                    }
                    catch (Exception ex) {
                        throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemFlushingBufferedData", (String[])new String[]{ex.getMessage()}), (Throwable)ex);
                    }
                    finally {
                        try {
                            this.targetTableWriteOperationManager.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    this.targetTable.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                try {
                    this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.ClosingConnectionToTable", (String[])new String[0]));
                    this.targetTable = null;
                    this.m_hbAdmin.close();
                }
                catch (Exception ex) {
                    throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemWhenClosingConnection", (String[])new String[]{ex.getMessage()}), (Throwable)ex);
                }
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.m_meta = (HBaseOutputMeta)smi;
            this.m_data = (HBaseOutputData)sdi;
            try {
                this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.ConnectingToHBase", (String[])new String[0]));
                ArrayList connectionMessages = new ArrayList();
                this.hBaseService = (HBaseService)this.namedClusterServiceLocator.getService(this.m_meta.getNamedCluster(), HBaseService.class);
                this.m_hbAdmin = this.hBaseService.getHBaseConnection((VariableSpace)this, this.environmentSubstitute(this.m_meta.getCoreConfigURL()), this.environmentSubstitute(this.m_meta.getDefaultConfigURL()), this.log);
                this.m_bytesUtil = this.hBaseService.getByteConversionUtil();
                if (connectionMessages.size() > 0) {
                    for (String m : connectionMessages) {
                        this.logBasic(m);
                    }
                }
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.UnableToObtainConnection", (String[])new String[]{ex.getMessage()}), (Throwable)ex);
            }
            try {
                this.m_mappingAdmin = new MappingAdmin(this.m_hbAdmin);
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.UnableToObtainConnection", (String[])new String[]{ex.getMessage()}), (Throwable)ex);
            }
            String targetName = this.environmentSubstitute(this.m_meta.getTargetTableName());
            if (Utils.isEmpty((CharSequence)targetName)) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.NoTargetTableSpecified", (String[])new String[0]));
            }
            try {
                this.targetTable = this.m_hbAdmin.getTable(targetName);
                if (!this.targetTable.exists()) {
                    throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.TargetTableDoesNotExist", (String[])new String[]{targetName}));
                }
                if (this.targetTable.disabled() || !this.targetTable.available()) {
                    throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.TargetTableIsNotAvailable", (String[])new String[]{targetName}));
                }
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemWhenCheckingAvailReadiness", (String[])new String[]{targetName, ex.getMessage()}), (Throwable)ex);
            }
            if (this.m_meta.getMapping() != null && Utils.isEmpty((CharSequence)this.m_meta.getTargetMappingName())) {
                this.m_tableMapping = this.m_meta.getMapping();
            } else {
                try {
                    this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.RetrievingMappingDetails", (String[])new String[0]));
                    this.m_tableMapping = this.m_mappingAdmin.getMapping(this.environmentSubstitute(this.m_meta.getTargetTableName()), this.environmentSubstitute(this.m_meta.getTargetMappingName()));
                }
                catch (Exception ex) {
                    throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemGettingMappingInfo", (String[])new String[]{ex.getMessage()}), (Throwable)ex);
                }
            }
            this.m_columnsMappedByAlias = this.m_tableMapping.getMappedColumns();
            if (!this.m_meta.m_deleteRowKey && this.m_tableMapping.isTupleMapping()) {
                try {
                    this.tupleRowConverter = new KettleRowToHBaseTuple(this.getInputRowMeta(), this.m_tableMapping, this.m_columnsMappedByAlias);
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
            } else {
                boolean incomingKey = false;
                RowMetaInterface inMeta = this.getInputRowMeta();
                for (int i = 0; i < inMeta.size(); ++i) {
                    ValueMetaInterface vm = inMeta.getValueMeta(i);
                    String inName = vm.getName();
                    if (this.m_tableMapping.getKeyName().equals(inName)) {
                        incomingKey = true;
                        this.m_incomingKeyIndex = i;
                        this.m_incomingKeyValueMeta = vm;
                        continue;
                    }
                    HBaseValueMetaInterface hvm = this.m_columnsMappedByAlias.get(inName.trim());
                    if (hvm != null || this.m_meta.getDeleteRowKey()) continue;
                    throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.CantFindIncomingField", (String[])new String[]{inName, this.m_tableMapping.getMappingName()}));
                }
                if (!incomingKey) {
                    throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.TableKeyNotPresentInIncomingFields", (String[])new String[]{this.m_tableMapping.getKeyName(), this.m_tableMapping.getMappingName()}));
                }
            }
            try {
                this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.ConnectingToTargetTable", (String[])new String[0]));
                Long writeBufferSize = null;
                if (!Utils.isEmpty((CharSequence)this.m_meta.getWriteBufferSize())) {
                    writeBufferSize = Long.parseLong(this.environmentSubstitute(this.m_meta.getWriteBufferSize()));
                    this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.SettingWriteBuffer", (Object[])new Object[]{writeBufferSize}));
                    if (this.m_meta.getDisableWriteToWAL()) {
                        this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.DisablingWriteToWAL", (String[])new String[0]));
                    }
                }
                this.targetTableWriteOperationManager = this.targetTable.createWriteOperationManager(writeBufferSize);
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemConnectingToTargetTable", (String[])new String[]{e.getMessage()}), (Throwable)e);
            }
            this.m_data.setOutputRowMeta(this.getInputRowMeta());
        }
        if (this.m_meta.getDeleteRowKey()) {
            try {
                if (this.m_incomingKeyValueMeta.isNull(r[this.m_incomingKeyIndex])) {
                    throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.IncomingRowHasNullKeyValue", (String[])new String[0]));
                }
                byte[] encodedKeyBytes = this.m_bytesUtil.encodeKeyValue(r[this.m_incomingKeyIndex], this.m_incomingKeyValueMeta, this.m_tableMapping.getKeyType());
                HBaseDelete hBaseDelete = this.targetTableWriteOperationManager.createDelete(encodedKeyBytes);
                hBaseDelete.execute();
            }
            catch (Exception ex) {
                if (this.getStepMeta().isDoingErrorHandling()) {
                    errorDescriptions2 = "";
                    errorDescriptions2 = !Utils.isEmpty((CharSequence)ex.getMessage()) ? ex.getMessage() : BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ErrorCreatingDelete", (String[])new String[0]);
                    this.putError(this.getInputRowMeta(), r, 1L, errorDescriptions2, this.m_tableMapping.getKeyName(), "HBaseOutput004");
                    return true;
                }
                throw new KettleException((Throwable)ex);
            }
        }
        if (this.tupleRowConverter != null) {
            try {
                hBasePut = this.tupleRowConverter.createTuplePut(this.targetTableWriteOperationManager, this.m_bytesUtil, r, !this.m_meta.getDisableWriteToWAL());
            }
            catch (Exception ex) {
                if (this.getStepMeta().isDoingErrorHandling()) {
                    errorDescriptions = "";
                    String errorFields = "Unknown";
                    if (ex instanceof KettleRowToHBaseTuple.FieldException) {
                        errorFields = ((KettleRowToHBaseTuple.FieldException)ex).getFieldString();
                        errorDescriptions = BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.MissingFieldData", (String[])new String[]{errorFields});
                    } else {
                        errorDescriptions = !Utils.isEmpty((CharSequence)ex.getMessage()) ? ex.getMessage() : BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ErrorCreatingPut", (String[])new String[0]);
                    }
                    this.putError(this.getInputRowMeta(), r, 1L, errorDescriptions, errorFields, "HBaseOutput003");
                    return true;
                }
                throw new KettleException((Throwable)ex);
            }
        }
        try {
            hBasePut = HBaseOutputData.initializeNewPut(this.getInputRowMeta(), this.m_incomingKeyIndex, r, this.m_tableMapping, this.m_bytesUtil, this.targetTableWriteOperationManager, !this.m_meta.getDisableWriteToWAL());
            if (hBasePut == null) {
                errorDescriptions2 = BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.IncomingRowHasNullKeyValue", (String[])new String[0]);
                if (this.getStepMeta().isDoingErrorHandling()) {
                    String errorFields = this.m_tableMapping.getKeyName();
                    this.putError(this.getInputRowMeta(), r, 1L, errorDescriptions2, errorFields, "HBaseOutput001");
                    return true;
                }
                throw new KettleException(errorDescriptions2);
            }
        }
        catch (Exception ex) {
            throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.UnableToSetTargetTable", (String[])new String[0]), (Throwable)ex);
        }
        HBaseOutputData.addColumnsToPut(this.getInputRowMeta(), r, this.m_incomingKeyIndex, this.m_columnsMappedByAlias, hBasePut, this.m_bytesUtil);
        try {
            hBasePut.execute();
        }
        catch (Exception e) {
            errorDescriptions = BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemInsertingRowIntoHBase", (String[])new String[]{e.getMessage()});
            if (this.getStepMeta().isDoingErrorHandling()) {
                String errorFields = "Unknown";
                this.putError(this.getInputRowMeta(), r, 1L, errorDescriptions, errorFields, "HBaseOutput002");
            }
            throw new KettleException(errorDescriptions, (Throwable)e);
        }
        this.putRow(this.m_data.getOutputRowMeta(), r);
        if (this.log.isRowLevel()) {
            this.log.logRowlevel(this.toString(), new Object[]{"Read row #" + this.getLinesRead() + " : " + r});
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        if (super.init(smi, sdi)) {
            HBaseOutputMeta meta = (HBaseOutputMeta)smi;
            try {
                meta.applyInjection((VariableSpace)this);
                return true;
            }
            catch (KettleException e) {
                this.logError("Error while injecting properties", e);
            }
        }
        return false;
    }

    public void setStopped(boolean stopped) {
        if (this.isStopped() && stopped) {
            return;
        }
        super.setStopped(stopped);
        if (stopped) {
            if (this.targetTable != null) {
                try {
                    if (!this.targetTableWriteOperationManager.isAutoFlush()) {
                        this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.FlushingWriteBuffer", (String[])new String[0]));
                        this.targetTableWriteOperationManager.flushCommits();
                    }
                }
                catch (Exception ex) {
                    this.logError(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemFlushingBufferedData", (String[])new String[]{ex.getMessage()}), ex);
                }
            }
            if (this.m_hbAdmin != null) {
                try {
                    this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.ClosingConnectionToTable", (String[])new String[0]));
                    this.m_hbAdmin.close();
                }
                catch (Exception ex) {
                    this.logError(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemWhenClosingConnection", (String[])new String[]{ex.getMessage()}), ex);
                }
            }
        }
    }
}

