/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ReplicationSourceWALActionListener
implements WALActionsListener {
    private final Configuration conf;
    private final ReplicationSourceManager manager;

    public ReplicationSourceWALActionListener(Configuration conf, ReplicationSourceManager manager) {
        this.conf = conf;
        this.manager = manager;
    }

    @Override
    public void preLogRoll(Path oldPath, Path newPath) throws IOException {
        this.manager.preLogRoll(newPath);
    }

    @Override
    public void postLogRoll(Path oldPath, Path newPath) throws IOException {
        this.manager.postLogRoll(newPath);
    }

    @Override
    public void visitLogEntryBeforeWrite(WALKey logKey, WALEdit logEdit) throws IOException {
        ReplicationSourceWALActionListener.scopeWALEdits(logKey, logEdit, this.conf);
    }

    @VisibleForTesting
    static void scopeWALEdits(WALKey logKey, WALEdit logEdit, Configuration conf) throws IOException {
        WALProtos.RegionEventDescriptor maybeEvent;
        boolean replicationForBulkLoadEnabled = ReplicationUtils.isReplicationForBulkLoadDataEnabled((Configuration)conf);
        boolean foundOtherEdits = false;
        for (Cell cell : logEdit.getCells()) {
            if (CellUtil.matchingFamily((Cell)cell, (byte[])WALEdit.METAFAMILY)) continue;
            foundOtherEdits = true;
            break;
        }
        if (!foundOtherEdits && logEdit.getCells().size() > 0 && (maybeEvent = WALEdit.getRegionEventDescriptor(logEdit.getCells().get(0))) != null && maybeEvent.getEventType() == WALProtos.RegionEventDescriptor.EventType.REGION_CLOSE) {
            foundOtherEdits = true;
        }
        if (!replicationForBulkLoadEnabled && !foundOtherEdits || logEdit.isReplay()) {
            ((WALKeyImpl)logKey).serializeReplicationScope(false);
        }
    }
}

