/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.jface.tags;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.jface.tags.JfaceMenuList;
import org.pentaho.ui.xul.jface.tags.JfaceMenupopup;
import org.pentaho.ui.xul.swt.SwtElement;
import org.pentaho.ui.xul.util.XulUtil;

public class JfaceMenuitem
extends SwtElement
implements XulMenuitem {
    private static int menuItemSerial = 0;
    private static final Log logger = LogFactory.getLog(JfaceMenuitem.class);
    private String onCommand;
    private boolean disabled = false;
    private XulDomContainer domContainer;
    private XulComponent parent;
    private String remainder;
    private ActionContributionItem contributionItem;
    private String acceltext = "";
    private String accesskey = "";
    private String label = "";
    private String image = "";
    private boolean selected = false;

    public JfaceMenuitem(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        this(self, parent, domContainer, tagName, -1, null, parent.getManagedObject() != null && parent.getManagedObject() instanceof IMenuManager, false);
    }

    public JfaceMenuitem(Element self, XulComponent parent, XulDomContainer domContainer, String tagName, int pos) {
        this(self, parent, domContainer, tagName, pos, null, parent.getManagedObject() != null && parent.getManagedObject() instanceof IMenuManager, true);
    }

    public JfaceMenuitem(Element self, XulComponent parent, XulDomContainer domContainer, String tagName, int pos, Action action) {
        this(self, parent, domContainer, tagName, pos, action, true, true);
    }

    private JfaceMenuitem(Element self, XulComponent parent, XulDomContainer domContainer, String tagName, int pos, Action action, boolean shouldCreate, boolean autoAdd) {
        super("menuitem");
        this.parent = parent;
        this.domContainer = domContainer;
        if (shouldCreate) {
            this.createItem(self, parent, pos, autoAdd, action);
        }
    }

    public void setAction(Action action) {
        this.contributionItem = new ActionContributionItem((IAction)action);
    }

    public IAction getAction() {
        return this.contributionItem.getAction();
    }

    private Action initAction(Element self, Action alternativeAction) {
        int style = 4;
        if (self != null && "checkbox".equals(self.getAttributeValue("type"))) {
            style = 2;
        }
        Action action = alternativeAction != null ? alternativeAction : new Action(self != null ? self.getAttributeValue("label") : "tmp name", style){

            public void run() {
                String command = JfaceMenuitem.this.onCommand;
                if (command != null) {
                    try {
                        JfaceMenuitem.this.invoke(command);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        String id = this.getId();
        if (id == null && self != null) {
            id = self.getAttributeValue("ID");
        }
        if (id == null) {
            id = "menuitem-" + menuItemSerial;
            ++menuItemSerial;
        }
        action.setId(id);
        action.setChecked(this.selected);
        return action;
    }

    public void createItem(Element self, XulComponent parent, int pos, boolean autoAdd) {
        this.createItem(self, parent, pos, autoAdd, null);
    }

    public void createItem(Element self, XulComponent parent, int pos, boolean autoAdd, Action alternativeAction) {
        this.contributionItem = new ActionContributionItem((IAction)this.initAction(self, alternativeAction));
        this.setManagedObject(this.contributionItem);
        if (autoAdd) {
            IMenuManager menu = (IMenuManager)parent.getManagedObject();
            if (pos == -1) {
                menu.add((IContributionItem)this.contributionItem);
            } else if (pos < this.getChildNodes().size()) {
                String anchorId = menu.getItems()[pos].getId();
                if (anchorId == null) {
                    menu.add((IContributionItem)this.contributionItem);
                    parent.addChild((Element)this);
                } else {
                    menu.insertBefore(anchorId, (IContributionItem)this.contributionItem);
                    parent.addChildAt((Element)this, pos);
                }
            } else {
                parent.addChild((Element)this);
            }
        }
    }

    public String getAcceltext() {
        return this.acceltext;
    }

    public String getAccesskey() {
        return this.accesskey;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public String getLabel() {
        return this.label;
    }

    public void setAcceltext(String accel) {
        this.acceltext = accel;
        this.setText();
    }

    private void setText() {
        if (this.contributionItem != null) {
            String text = "";
            if (this.label != null) {
                text = text + this.label;
            }
            if (!this.acceltext.isEmpty()) {
                text = text + "\t" + this.acceltext;
            }
            this.contributionItem.getAction().setText(text);
        }
    }

    public void setAccesskey(String accessKey) {
        if (this.contributionItem != null) {
            int mask = 0;
            if (accessKey.indexOf("ctrl") > -1) {
                boolean isMac = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
                mask += isMac ? 0x400000 : 262144;
            }
            if (accessKey.indexOf("shift") > -1) {
                mask += 131072;
            }
            if (accessKey.indexOf("alt") > -1) {
                mask += 65536;
            }
            if (accessKey.indexOf("pageup") > -1) {
                mask += 0x1000005;
            }
            if (accessKey.indexOf("pagedown") > -1) {
                mask += 0x1000006;
            }
            if (accessKey.indexOf("home") > -1) {
                mask += 0x1000007;
            }
            if (accessKey.indexOf("esc") > -1) {
                mask += 27;
            }
            this.remainder = accessKey.replaceAll("ctrl", "").replaceAll("shift", "").replaceAll("alt", "").replaceAll("-", "").trim();
            if (this.remainder.length() == 1) {
                mask += this.remainder.toUpperCase().charAt(0);
            } else if (this.remainder.length() > 1 && this.remainder.startsWith("f")) {
                mask += LegacyActionTools.findKeyCode((String)this.remainder);
            }
            this.contributionItem.getAction().setAccelerator(mask);
            this.contributionItem.update("text");
        }
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (this.contributionItem != null) {
            this.contributionItem.getAction().setEnabled(!disabled);
        }
    }

    public void setLabel(String label) {
        this.label = label;
        this.setText();
    }

    public String getImage() {
        return this.image;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean val) {
        boolean changing = this.selected != val;
        this.selected = val;
        if (this.contributionItem != null) {
            this.contributionItem.getAction().setChecked(this.selected);
        }
        if (this.parent != null && this.parent instanceof JfaceMenupopup && this.parent.getParent() instanceof JfaceMenuList) {
            if (val) {
                ((JfaceMenuList)this.parent.getParent()).setSelectedItem(this);
            } else if (changing) {
                ((JfaceMenuList)this.parent.getParent()).setSelectedItem(null);
            }
        }
    }

    public void setImage(Image img) {
        ImageDescriptor id = ImageDescriptor.createFromImage((Image)img);
        if (this.contributionItem != null) {
            this.contributionItem.getAction().setImageDescriptor(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(String image) {
        this.image = image;
        if (StringUtils.isNotEmpty((String)image)) {
            InputStream in = null;
            try {
                in = XulUtil.loadResourceAsStream((String)image, (XulDomContainer)this.domContainer);
                Image img = new Image((Device)Display.getCurrent(), in);
                ImageDescriptor id = ImageDescriptor.createFromImage((Image)img);
                if (this.contributionItem != null) {
                    this.contributionItem.getAction().setImageDescriptor(id);
                }
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getCommand() {
        return this.onCommand;
    }

    public void setCommand(String command) {
        this.onCommand = command;
    }

    public String toString() {
        return this.getLabel();
    }

    public void reposition(int position) {
        this.contributionItem = null;
        this.createItem((Element)this, this.parent, position, true);
        this.setDisabled(this.isDisabled());
        this.setImage(this.getImage());
        this.setSelected(this.isSelected());
        this.setAcceltext(this.getAcceltext());
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.contributionItem.setVisible(visible);
    }
}

