/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Expression;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.swing.tags.SwingListitem;
import org.pentaho.ui.xul.util.Orient;

public class SwingListbox
extends AbstractSwingContainer
implements XulListbox,
ListSelectionListener {
    private static final long serialVersionUID = 3064125049914932493L;
    private JList listBox;
    private DefaultListModel model;
    private boolean disabled = false;
    private String selType;
    private int rowsToDisplay = 0;
    private String onselect;
    private JScrollPane scrollPane;
    private static final Log logger = LogFactory.getLog(SwingListbox.class);
    private XulDomContainer xulDomContainer;
    private String command;
    private String binding;
    private int[] curSelectedIndices = new int[0];
    private int curSelectedIndex = -1;
    private boolean suppressEvents;
    private Collection boundElements;

    public SwingListbox(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        super(tagName);
        this.model = new DefaultListModel();
        this.listBox = new JList(this.model);
        this.scrollPane = new JScrollPane(this.listBox);
        this.listBox.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.listBox.addListSelectionListener(this);
        this.setManagedObject(this.scrollPane);
        this.xulDomContainer = container;
        Dimension size = this.scrollPane.getPreferredSize();
        this.scrollPane.setMinimumSize(size);
    }

    public Object getManagedObject() {
        return super.getManagedObject();
    }

    @Override
    public boolean isDisabled() {
        return !this.listBox.isEnabled();
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.listBox.setEnabled(!disabled);
    }

    public void setDisabled(String disabled) {
        this.listBox.setEnabled(!Boolean.parseBoolean(disabled));
    }

    public int getRows() {
        return this.rowsToDisplay;
    }

    public void setRows(int rowsToDisplay) {
        this.rowsToDisplay = rowsToDisplay;
        this.listBox.setVisibleRowCount(rowsToDisplay);
    }

    public String getSeltype() {
        return this.selType;
    }

    public void setSeltype(String selType) {
        this.selType = selType;
        XulListbox.SEL_TYPE sel = XulListbox.SEL_TYPE.valueOf((String)selType.toUpperCase());
        if (sel == XulListbox.SEL_TYPE.SINGLE) {
            this.listBox.setSelectionMode(0);
        } else {
            this.listBox.setSelectionMode(2);
        }
    }

    @Override
    public Orient getOrientation() {
        return null;
    }

    @Override
    public void layout() {
        if (this.suppressEvents) {
            return;
        }
        this.model.clear();
        for (Element comp : this.getChildNodes()) {
            if (!(comp instanceof SwingListitem)) continue;
            this.model.addElement(comp);
            logger.info((Object)"added swingListitem to model");
        }
        if (this.curSelectedIndex > -1) {
            if (this.listBox.getModel().getSize() < this.curSelectedIndex) {
                this.setSelectedIndex(-1);
            } else {
                this.listBox.setSelectedIndex(this.curSelectedIndex);
            }
        }
        this.initialized = true;
    }

    public String getOnselect() {
        return this.onselect;
    }

    public void setOnselect(String onchange) {
        this.onselect = onchange;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() || this.suppressEvents) {
            return;
        }
        if (this.onselect != null && this.initialized) {
            this.invoke(this.onselect);
        }
        this.fireSetSelectedIndices(this.listBox.getSelectedIndices());
    }

    public Object getSelectedItem() {
        return this.listBox.getSelectedValue();
    }

    public Object[] getSelectedItems() {
        return this.listBox.getSelectedValues();
    }

    public void setSelectedItem(Object item) {
        this.listBox.setSelectedValue(item, true);
    }

    public void setSelectedItems(Object[] items) {
        int[] indices = new int[items.length];
        int index = -1;
        for (Object object : items) {
            indices[++index] = this.model.indexOf(object);
        }
        this.setSelectedIndices(indices);
    }

    public void setSelectedIndices(int[] indices) {
        this.listBox.setSelectedIndices(indices);
        this.fireSetSelectedIndices(indices);
    }

    private void fireSetSelectedIndices(int[] indices) {
        if (!Arrays.equals(this.curSelectedIndices, indices)) {
            this.changeSupport.firePropertyChange("selectedIndices", this.curSelectedIndices, indices);
            this.curSelectedIndices = indices;
        }
        int newSelectedIndex = this.getSelectedIndex();
        this.changeSupport.firePropertyChange("selectedIndex", this.curSelectedIndex, newSelectedIndex);
        if (this.boundElements != null) {
            String oldItem = this.curSelectedIndex > -1 && this.boundElements.toArray().length > this.curSelectedIndex ? this.boundElements.toArray()[this.curSelectedIndex] : "";
            Object newItem = newSelectedIndex > -1 && this.boundElements.toArray().length > newSelectedIndex ? this.boundElements.toArray()[newSelectedIndex] : null;
            this.changeSupport.firePropertyChange("selectedItem", oldItem, newItem);
        }
        this.curSelectedIndex = newSelectedIndex;
    }

    public void addItem(Object item) {
        this.model.addElement(item);
    }

    public void removeItems() {
        this.model.removeAllElements();
        for (XulComponent c : this.getChildNodes()) {
            this.removeChild((Element)c);
        }
    }

    public int getRowCount() {
        return this.model.getSize();
    }

    public int getSelectedIndex() {
        return this.listBox.getSelectedIndex();
    }

    public int[] getSelectedIndices() {
        return this.listBox.getSelectedIndices();
    }

    public void setSelectedindex(String idx) {
        this.setSelectedIndex(Integer.parseInt(idx));
    }

    public void setSelectedIndex(int index) {
        this.curSelectedIndex = index;
        if (this.initialized) {
            if (index == -1 && this.listBox.getModel().getSize() == 0) {
                this.listBox.setSelectedIndex(-1);
                this.fireSetSelectedIndices(new int[]{-1});
            } else {
                this.listBox.setSelectedIndex(index);
            }
        }
    }

    public <T> Collection<T> getElements() {
        return this.boundElements;
    }

    public <T> void setElements(Collection<T> elements) {
        this.suppressEvents = true;
        this.boundElements = elements;
        logger.info((Object)("SetElements on listbox called: collection has " + elements.size() + " rows"));
        this.model.removeAllElements();
        this.removeItems();
        for (T t : elements) {
            SwingListitem item = new SwingListitem(null, (XulComponent)this, this.xulDomContainer, null);
            String attribute = this.getBinding();
            item.setLabel(this.extractLabel(t));
            this.addChild((Element)item);
        }
        this.suppressEvents = false;
        this.layout();
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    private <T> String extractLabel(T t) {
        String attribute = this.getBinding();
        if (StringUtils.isEmpty((String)attribute)) {
            return t.toString();
        }
        String getter = "get" + String.valueOf(attribute.charAt(0)).toUpperCase() + attribute.substring(1);
        try {
            return new Expression(t, getter, null).getValue().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(final String command) {
        this.command = command;
        this.listBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    SwingListbox.this.invoke(command);
                }
            }
        });
    }
}

