/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.orm;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.util.FileListing;
import com.cloudera.sqoop.util.Jars;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Shell;

public class CompilationManager {
    public static final String DEFAULT_CODEGEN_JAR_NAME = "sqoop-codegen-created.jar";
    public static final Log LOG = LogFactory.getLog((String)CompilationManager.class.getName());
    private static final String INNER_CLASS_SEPARATOR = "$";
    private static final String CLASS_EXTENSION = ".class";
    private static final String JAVA_EXTENSION = ".java";
    private SqoopOptions options;
    private List<String> sources;
    private static final int BUFFER_SZ = 4096;

    public CompilationManager(SqoopOptions opts) {
        this.options = opts;
        this.sources = new ArrayList<String>();
    }

    public void addSourceFile(String sourceName) {
        this.sources.add(sourceName);
    }

    private String findHadoopJars() {
        String hadoopMapRedHome = this.options.getHadoopMapRedHome();
        if (null == hadoopMapRedHome) {
            LOG.info((Object)"$HADOOP_MAPRED_HOME is not set");
            return Jars.getJarPathForClass(JobConf.class);
        }
        if (!hadoopMapRedHome.endsWith(File.separator)) {
            hadoopMapRedHome = hadoopMapRedHome + File.separator;
        }
        File hadoopMapRedHomeFile = new File(hadoopMapRedHome);
        LOG.info((Object)("HADOOP_MAPRED_HOME is " + hadoopMapRedHomeFile.getAbsolutePath()));
        Iterator filesIterator = FileUtils.iterateFiles((File)hadoopMapRedHomeFile, (String[])new String[]{"jar"}, (boolean)true);
        StringBuilder sb = new StringBuilder();
        while (filesIterator.hasNext()) {
            File file = (File)filesIterator.next();
            String name = file.getName();
            if (!name.startsWith("hadoop-common") && !name.startsWith("hadoop-mapreduce-client-core") && !name.startsWith("hadoop-core")) continue;
            sb.append(file.getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        if (sb.length() < 1) {
            LOG.warn((Object)"HADOOP_MAPRED_HOME appears empty or missing");
            return Jars.getJarPathForClass(JobConf.class);
        }
        String s = sb.substring(0, sb.length() - 1);
        LOG.debug((Object)("Returning jar file path " + s));
        return s;
    }

    public void compile() throws IOException {
        Iterable<? extends JavaFileObject> srcFileObjs;
        JavaCompiler.CompilationTask task;
        boolean result;
        String sqoopJar;
        String coreJar;
        ArrayList<String> args = new ArrayList<String>();
        String jarOutDir = this.options.getJarOutputDir();
        File jarOutDirObj = new File(jarOutDir);
        if (!jarOutDirObj.exists()) {
            boolean mkdirSuccess = jarOutDirObj.mkdirs();
            if (!mkdirSuccess) {
                LOG.debug((Object)("Warning: Could not make directories for " + jarOutDir));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found existing " + jarOutDir));
        }
        if (!jarOutDir.endsWith(File.separator)) {
            jarOutDir = jarOutDir + File.separator;
        }
        if (null == (coreJar = this.findHadoopJars())) {
            String coreClassesPath = System.getProperty("hadoop.alt.classpath");
            if (null == coreClassesPath) {
                throw new IOException("Could not find hadoop core jar!");
            }
            coreJar = coreClassesPath;
        }
        if (null != (sqoopJar = Jars.getSqoopJarPath())) {
            sqoopJar = File.pathSeparator + sqoopJar;
        } else {
            LOG.warn((Object)"Could not find sqoop jar; child compilation may fail");
            sqoopJar = "";
        }
        String curClasspath = System.getProperty("java.class.path");
        LOG.debug((Object)("Current sqoop classpath = " + curClasspath));
        args.add("-sourcepath");
        args.add(jarOutDir);
        args.add("-d");
        args.add(jarOutDir);
        args.add("-classpath");
        args.add(curClasspath + File.pathSeparator + coreJar + sqoopJar);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (null == compiler) {
            LOG.error((Object)"It seems as though you are running sqoop with a JRE.");
            LOG.error((Object)"Sqoop requires a JDK that can compile Java code.");
            LOG.error((Object)"Please install a JDK and set $JAVA_HOME to use it.");
            throw new IOException("Could not start Java compiler.");
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        ArrayList<String> srcFileNames = new ArrayList<String>();
        for (String srcfile : this.sources) {
            srcFileNames.add(jarOutDir + srcfile);
            LOG.debug((Object)("Adding source file: " + jarOutDir + srcfile));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Invoking javac with args:");
            for (String arg : args) {
                LOG.debug((Object)("  " + arg));
            }
        }
        if (!(result = (task = compiler.getTask(null, fileManager, null, args, null, srcFileObjs = fileManager.getJavaFileObjectsFromStrings(srcFileNames))).call().booleanValue())) {
            throw new IOException("Error returned by javac");
        }
        String srcOutDir = new File(this.options.getCodeOutputDir()).getAbsolutePath();
        if (!srcOutDir.endsWith(File.separator)) {
            srcOutDir = srcOutDir + File.separator;
        }
        for (String srcFileName : this.sources) {
            String orig = jarOutDir + srcFileName;
            String dest = srcOutDir + srcFileName;
            File fOrig = new File(orig);
            File fDest = new File(dest);
            File fDestParent = fDest.getParentFile();
            if (null != fDestParent && !fDestParent.exists() && !fDestParent.mkdirs()) {
                LOG.error((Object)("Could not make directory: " + fDestParent));
            }
            try {
                FileUtils.moveFile((File)fOrig, (File)fDest);
            }
            catch (IOException e) {
                LOG.debug((Object)("Could not rename " + orig + " to " + dest));
            }
        }
    }

    public String getJarFilename() {
        String jarOutDir = this.options.getJarOutputDir();
        String tableName = this.options.getTableName();
        String specificClassName = this.options.getClassName();
        if (specificClassName != null && specificClassName.length() > 0) {
            return jarOutDir + specificClassName + ".jar";
        }
        if (null != tableName && tableName.length() > 0) {
            return jarOutDir + tableName + ".jar";
        }
        if (this.sources.size() == 1) {
            String srcFileName = this.sources.get(0);
            String basename = new File(srcFileName).getName();
            String[] parts = basename.split("\\.");
            String preExtPart = parts[0];
            return jarOutDir + preExtPart + ".jar";
        }
        return jarOutDir + DEFAULT_CODEGEN_JAR_NAME;
    }

    private void addClassFilesFromDir(File dir, JarOutputStream jstream) throws IOException {
        LOG.debug((Object)("Scanning for .class files in directory: " + dir));
        List<File> dirEntries = FileListing.getFileListing(dir);
        String baseDirName = dir.getAbsolutePath();
        if (!baseDirName.endsWith(File.separator)) {
            baseDirName = baseDirName + File.separator;
        }
        for (File entry : dirEntries) {
            String fullPath;
            String classFileName;
            if (entry.isDirectory() || !this.includeFileInJar(classFileName = (fullPath = entry.getAbsolutePath()).substring(baseDirName.length()))) continue;
            if (Shell.WINDOWS) {
                classFileName = classFileName.replace(File.separator, "/");
            }
            LOG.debug((Object)("Got classfile: " + entry.getPath() + " -> " + classFileName));
            ZipEntry ze = new ZipEntry(classFileName);
            jstream.putNextEntry(ze);
            this.copyFileToStream(entry, jstream);
            jstream.closeEntry();
        }
    }

    boolean includeFileInJar(String classFileName) {
        if (!classFileName.endsWith(CLASS_EXTENSION)) {
            return false;
        }
        String className = StringUtils.substringBeforeLast((String)classFileName, (String)CLASS_EXTENSION);
        String sourceFileOfClass = className + JAVA_EXTENSION;
        return this.isInnerClass(sourceFileOfClass) || this.isOuterClass(sourceFileOfClass);
    }

    boolean isInnerClass(String sourceFileName) {
        String potentialOuterClassName = this.potentialOuterClassNameOf(sourceFileName);
        String sourceFileOfPotentialOuterClass = potentialOuterClassName + JAVA_EXTENSION;
        return this.isOuterClass(sourceFileOfPotentialOuterClass);
    }

    boolean isOuterClass(String sourceFileOfClass) {
        return this.sources.contains(sourceFileOfClass);
    }

    String potentialOuterClassNameOf(String className) {
        return StringUtils.substringBeforeLast((String)className, (String)INNER_CLASS_SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jar() throws IOException {
        String jarOutDir = this.options.getJarOutputDir();
        String jarFilename = this.getJarFilename();
        LOG.info((Object)("Writing jar file: " + jarFilename));
        File jarFileObj = new File(jarFilename);
        if (jarFileObj.exists()) {
            LOG.debug((Object)("Found existing jar (" + jarFilename + "); removing."));
            if (!jarFileObj.delete()) {
                LOG.warn((Object)("Could not remove existing jar file: " + jarFilename));
            }
        }
        FileOutputStream fstream = null;
        ZipOutputStream jstream = null;
        try {
            fstream = new FileOutputStream(jarFilename);
            jstream = new JarOutputStream(fstream);
            this.addClassFilesFromDir(new File(jarOutDir), (JarOutputStream)jstream);
            jstream.finish();
        }
        finally {
            if (null != jstream) {
                try {
                    jstream.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("IOException closing jar stream: " + ioe.toString()));
                }
            }
            if (null != fstream) {
                try {
                    fstream.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("IOException closing file stream: " + ioe.toString()));
                }
            }
        }
        LOG.debug((Object)("Finished writing jar file " + jarFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileToStream(File f, OutputStream ostream) throws IOException {
        byte[] buffer = new byte[4096];
        try (FileInputStream fis = new FileInputStream(f);){
            int bytesReceived;
            while ((bytesReceived = fis.read(buffer)) >= 1) {
                ostream.write(buffer, 0, bytesReceived);
            }
        }
    }
}

