/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.impl;

import java.util.concurrent.Callable;
import org.apache.aries.proxy.ProxyManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.pentaho.osgi.api.ProxyUnwrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUnwrapperImpl
implements ProxyUnwrapper {
    private BundleContext bundleContext;
    private ProxyManager proxyManager;
    private static final Logger logger = LoggerFactory.getLogger(ProxyUnwrapperImpl.class);

    public ProxyUnwrapperImpl(BundleContext bundleContext) {
        this.setBundleContext(bundleContext);
        this.init();
    }

    private void init() {
        if (this.proxyManager == null) {
            ServiceReference serviceReference = this.bundleContext.getServiceReference(ProxyManager.class);
            this.proxyManager = (ProxyManager)this.bundleContext.getService(serviceReference);
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setProxyManager(ProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    public Object unwrap(Object proxyWrappedObject) {
        if (this.proxyManager.isProxy(proxyWrappedObject)) {
            Callable callable = this.proxyManager.unwrap(proxyWrappedObject);
            try {
                proxyWrappedObject = callable.call();
            }
            catch (Exception e) {
                logger.error("Could not unwrap proxied object", (Throwable)e);
            }
        }
        return proxyWrappedObject;
    }
}

