/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;

public class TypeConverterStringMapping
extends TypeConverterMapping {
    @Override
    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        Class fieldType = clr.classForName(type);
        Class datastoreType = TypeManager.getDatastoreTypeForTypeConverter((TypeConverter)this.converter, (Class)fieldType);
        if (!String.class.isAssignableFrom(datastoreType)) {
            throw new NucleusException("Attempt to create TypeConverterStringMapping for type " + type + " yet this is not using String in the datastore");
        }
    }

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        this.initialize(mmd, table, clr, null);
    }

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr, TypeConverter conv) {
        super.initialize(mmd, table, clr, conv);
        Class datastoreType = TypeManager.getDatastoreTypeForTypeConverter((TypeConverter)this.converter, (Class)mmd.getType());
        if (!String.class.isAssignableFrom(datastoreType)) {
            throw new NucleusException("Attempt to create TypeConverterStringMapping for member " + mmd.getFullFieldName() + " yet this is not using String in the datastore");
        }
    }

    @Override
    public String getJavaTypeForDatastoreMapping(int index) {
        return String.class.getName();
    }
}

