/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.quotas.FileArchiverNotifier;
import org.apache.hadoop.hbase.quotas.FileArchiverNotifierFactory;
import org.apache.hadoop.hbase.quotas.FileArchiverNotifierImpl;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class FileArchiverNotifierFactoryImpl
implements FileArchiverNotifierFactory {
    private static final FileArchiverNotifierFactoryImpl DEFAULT_INSTANCE = new FileArchiverNotifierFactoryImpl();
    private static volatile FileArchiverNotifierFactory CURRENT_INSTANCE = DEFAULT_INSTANCE;
    private final ConcurrentHashMap<TableName, FileArchiverNotifier> CACHE = new ConcurrentHashMap();

    private FileArchiverNotifierFactoryImpl() {
    }

    public static FileArchiverNotifierFactory getInstance() {
        return CURRENT_INSTANCE;
    }

    @VisibleForTesting
    static void setInstance(FileArchiverNotifierFactory inst) {
        CURRENT_INSTANCE = Objects.requireNonNull(inst);
    }

    @VisibleForTesting
    static void reset() {
        CURRENT_INSTANCE = DEFAULT_INSTANCE;
    }

    @Override
    public FileArchiverNotifier get(Connection conn, Configuration conf, FileSystem fs, TableName tn) {
        FileArchiverNotifierImpl newMapping = new FileArchiverNotifierImpl(conn, conf, fs, tn);
        FileArchiverNotifier previousMapping = this.CACHE.putIfAbsent(tn, newMapping);
        if (previousMapping == null) {
            return newMapping;
        }
        return previousMapping;
    }

    public int getCacheSize() {
        return this.CACHE.size();
    }

    static class CacheKey {
        final Connection conn;
        final Configuration conf;
        final FileSystem fs;
        final TableName tn;

        CacheKey(Connection conn, Configuration conf, FileSystem fs, TableName tn) {
            this.conn = conn;
            this.conf = conf;
            this.fs = fs;
            this.tn = tn;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.tn.equals((Object)other.tn) && this.conn.equals(other.conn) && this.conf.equals(other.conf) && this.fs.equals(other.fs);
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.conn).append((Object)this.conf).append((Object)this.fs).append((Object)this.tn).toHashCode();
        }

        public String toString() {
            return "CacheKey[TableName=" + this.tn + "]";
        }
    }
}

