/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.scriptable.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.DataFactoryReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.scriptable.ScriptableDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.scriptable.parser.ConfigReadHandler;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ScriptableDataSourceReadHandler
extends AbstractXmlReadHandler
implements DataFactoryReadHandler {
    private ConfigReadHandler configReadHandler;
    private ArrayList<PropertyReadHandler> queries = new ArrayList();
    private ScriptableDataFactory dataFactory;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("config".equals(tagName)) {
            this.configReadHandler = new ConfigReadHandler();
            return this.configReadHandler;
        }
        if ("query".equals(tagName)) {
            PropertyReadHandler queryReadHandler = new PropertyReadHandler();
            this.queries.add(queryReadHandler);
            return queryReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        ScriptableDataFactory srdf = new ScriptableDataFactory();
        if (this.configReadHandler == null) {
            throw new ParseException("Required element 'config' is missing.", this.getLocator());
        }
        srdf.setLanguage(this.configReadHandler.getLanguage());
        if (!StringUtils.isEmpty((String)this.configReadHandler.getScript())) {
            srdf.setScript(this.configReadHandler.getScript());
        }
        if (!StringUtils.isEmpty((String)this.configReadHandler.getShutdownScript())) {
            srdf.setShutdownScript(this.configReadHandler.getShutdownScript());
        }
        for (int i = 0; i < this.queries.size(); ++i) {
            PropertyReadHandler handler = this.queries.get(i);
            srdf.setQuery(handler.getName(), handler.getResult());
        }
        this.dataFactory = srdf;
    }

    public Object getObject() throws SAXException {
        return this.dataFactory;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }
}

