/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import nickyb.sqleonardo.querybuilder.DiagramLoader;
import nickyb.sqleonardo.querybuilder.ViewDiagram;
import nickyb.sqleonardo.querybuilder.beans.Entity;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class EntityDropTargetListener
implements DropTargetListener {
    private ViewDiagram viewDiagram = null;
    private static final DataFlavor entityDataFlavor = new DataFlavor(Entity.class, Entity.class.getName());

    public EntityDropTargetListener(ViewDiagram viewdiagram) {
        this.setViewDiagram(viewdiagram);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
            return;
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        if (!this.isDragAcceptable(event)) {
            event.rejectDrag();
            return;
        }
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (!this.isDropAcceptable(event)) {
            event.rejectDrop();
            return;
        }
        event.acceptDrop(1);
        Transferable transferable = event.getTransferable();
        try {
            Entity entity = (Entity)transferable.getTransferData(entityDataFlavor);
            QueryTokens.Table token = new QueryTokens.Table(entity.getSchema(), entity.getEntityName());
            DiagramLoader.run(0, this.viewDiagram.getBuilder(), token, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        event.dropComplete(true);
    }

    public boolean isDropAcceptable(DropTargetDropEvent event) {
        return event.getCurrentDataFlavorsAsList().contains(entityDataFlavor);
    }

    public boolean isDragAcceptable(DropTargetDragEvent event) {
        return event.getCurrentDataFlavorsAsList().contains(entityDataFlavor);
    }

    public ViewDiagram getViewDiagram() {
        return this.viewDiagram;
    }

    public void setViewDiagram(ViewDiagram viewDiagram) {
        this.viewDiagram = viewDiagram;
    }
}

