/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.querybuilder.DiagramLoader;
import nickyb.sqleonardo.querybuilder.ObjectsListCellRenderer;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.beans.Entity;
import nickyb.sqleonardo.querybuilder.beans.Tag;
import nickyb.sqleonardo.querybuilder.dnd.EntityTransferHandler;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class ViewObjects
extends BorderLayoutPanel
implements ItemListener {
    public static final String ALL_TABLE_TYPES = "All";
    private QueryBuilder builder;
    private JList jListObjects;
    private JComboBox jComboBoxSchemas;
    private JComboBox jComboBoxTypes;

    ViewObjects(QueryBuilder builder) {
        this.builder = builder;
        this.initComponents();
    }

    private void initComponents() {
        this.jListObjects = new JList();
        this.jListObjects.setDragEnabled(true);
        this.jListObjects.setTransferHandler(new EntityTransferHandler());
        this.jListObjects.setCellRenderer(new ObjectsListCellRenderer());
        this.jListObjects.addMouseListener(new ClickHandler());
        JPanel pnlNorth = new JPanel(new GridLayout(0, 2));
        this.jComboBoxSchemas = new JComboBox();
        pnlNorth.add(this.jComboBoxSchemas);
        this.jComboBoxSchemas.setToolTipText(I18n.getString("querybuilder.tooltip.schemaFilter", "schema filter"));
        this.jComboBoxTypes = new JComboBox();
        pnlNorth.add(this.jComboBoxTypes);
        this.jComboBoxTypes.setToolTipText(I18n.getString("querybuilder.tooltip.typeFilter", "type filter"));
        this.setComponentNorth(pnlNorth);
        this.setComponentCenter(new JScrollPane(this.jListObjects));
    }

    void onConnectionChanged() throws SQLException {
        this.setCursor(new Cursor(3));
        this.jListObjects.setListData(new Vector());
        this.jComboBoxSchemas.removeItemListener(this);
        this.jComboBoxTypes.removeItemListener(this);
        this.jComboBoxSchemas.removeAllItems();
        this.jComboBoxTypes.removeAllItems();
        this.jComboBoxSchemas.setEnabled(false);
        this.jComboBoxTypes.setEnabled(false);
        if (this.builder.getConnection() != null) {
            DatabaseMetaData dbmd = this.builder.getConnection().getMetaData();
            ResultSet rsTypes = dbmd.getTableTypes();
            while (rsTypes.next()) {
                String type = rsTypes.getString(1).trim();
                boolean added = false;
                for (int i = 0; !added && i < this.jComboBoxTypes.getItemCount(); ++i) {
                    Tag t = (Tag)this.jComboBoxTypes.getItemAt(i);
                    added = type.equals(t.getValue().toString());
                }
                if (added) continue;
                this.jComboBoxTypes.addItem(new Tag(type, I18n.getString("querybuilder.objetctype." + type, "" + type)));
            }
            rsTypes.close();
            this.jComboBoxTypes.addItem(new Tag(ALL_TABLE_TYPES, I18n.getString("querybuilder.objetctype.all", "All object types")));
            if (ViewObjects.jdbcUseSchema(dbmd)) {
                ResultSet rsSchemas = dbmd.getSchemas();
                while (rsSchemas.next()) {
                    this.jComboBoxSchemas.addItem(rsSchemas.getString(1).trim());
                }
                rsSchemas.close();
            }
            this.jComboBoxSchemas.setSelectedItem(null);
            this.jComboBoxTypes.setSelectedItem(null);
        }
        this.jComboBoxSchemas.setEnabled(this.jComboBoxSchemas.getItemCount() > 0);
        this.jComboBoxTypes.setEnabled(this.jComboBoxTypes.getItemCount() > 0);
        this.jComboBoxSchemas.addItemListener(this);
        this.jComboBoxTypes.addItemListener(this);
        if (this.jComboBoxTypes.getItemCount() > 0 && QueryBuilder.loadObjectsAtOnce) {
            Tag t = new Tag("TABLE", I18n.getString("querybuilder.objetctype.TABLE", "TABLE"));
            for (int i = 0; i < this.jComboBoxTypes.getItemCount(); ++i) {
                if (!this.jComboBoxTypes.getItemAt(i).toString().equals(t.toString())) continue;
                this.jComboBoxTypes.setSelectedIndex(i);
                break;
            }
        }
        this.setCursor(new Cursor(0));
    }

    void onModelChanged() {
        String schema = this.builder.getQueryModel().getSchema();
        this.jComboBoxSchemas.setEnabled(this.jComboBoxSchemas.isEnabled() && schema == null);
        this.jComboBoxSchemas.setSelectedItem(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object schema = this.jComboBoxSchemas.getSelectedItem();
        Tag t = (Tag)this.jComboBoxTypes.getSelectedItem();
        Object type = null;
        if (t != null) {
            type = t.getValue();
        }
        if (!(type == null || schema == null && this.jComboBoxSchemas.isEnabled())) {
            this.setCursor(new Cursor(3));
            Vector<Entity> vObjects = new Vector<Entity>();
            String[] tableType = type.toString().equals(ALL_TABLE_TYPES) ? null : new String[]{type.toString()};
            try {
                DatabaseMetaData dbmd = this.builder.getConnection().getMetaData();
                String catalog = schema == null ? null : dbmd.getConnection().getCatalog();
                ResultSet rsTables = dbmd.getTables(catalog, schema == null ? null : schema.toString(), "%", tableType);
                if (rsTables != null) {
                    if (this.builder.getQueryModel().getSchema() != null) {
                        schema = null;
                    }
                    while (rsTables.next()) {
                        Entity entity = new Entity(schema == null ? null : schema.toString(), rsTables.getString(3).trim());
                        vObjects.addElement(entity);
                    }
                    rsTables.close();
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            finally {
                this.jListObjects.setListData(vObjects);
                this.setCursor(new Cursor(0));
            }
        }
    }

    public static boolean jdbcUseSchema(DatabaseMetaData dbmd) throws SQLException {
        String term = dbmd.getSchemaTerm();
        return term != null && term.length() > 0;
    }

    private class ClickHandler
    extends MouseAdapter {
        private ClickHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Entity selectedItem = (Entity)ViewObjects.this.jListObjects.getSelectedValue();
                QueryTokens.Table token = new QueryTokens.Table(selectedItem.getSchema(), selectedItem.getEntityName());
                DiagramLoader.run(0, ViewObjects.this.builder, token, true);
            }
        }
    }
}

