/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.querybuilder.DiagramAbstractEntity;
import nickyb.sqleonardo.querybuilder.DiagramField;
import nickyb.sqleonardo.querybuilder.MaskJoin;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.ViewDiagram;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class DiagramRelation
extends JPanel {
    public static Color highlightColor = Color.black;
    public static Color normalColor = Color.lightGray;
    private static Stroke highlightStroke = new BasicStroke(2.0f);
    private static Stroke normalStroke = new BasicStroke(2.0f);
    QueryTokens.Join querytoken;
    DiagramAbstractEntity primaryEntity;
    DiagramField primaryField;
    DiagramAbstractEntity foreignEntity;
    DiagramField foreignField;
    Anchor anchor;
    ViewDiagram owner;
    private boolean highlight = false;
    private Point[] serie = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0)};

    DiagramRelation(ViewDiagram owner) {
        this.owner = owner;
        this.setLayout(null);
        this.setOpaque(false);
        this.anchor = new Anchor();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.onPropertyChanged();
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean b) {
        this.highlight = b;
        this.repaint();
    }

    QueryTokens.Join getQueryToken() {
        return this.querytoken;
    }

    void setQueryToken(QueryTokens.Join token) {
        this.querytoken = token;
        this.onPropertyChanged();
    }

    void setValues(int jointype, String operator) {
        this.querytoken.setType(jointype);
        this.querytoken.getCondition().setOperator(operator);
        this.onPropertyChanged();
    }

    private void onPropertyChanged() {
        String tip = this.querytoken.getCondition().toString();
        if (this.getName() != null) {
            tip = "[ " + this.getName() + " ] " + tip;
        }
        this.anchor.setToolTipText(tip);
        switch (this.querytoken.getType()) {
            case 1: 
            case 2: {
                this.anchor.setBackground(Color.yellow);
                break;
            }
            case 3: {
                this.anchor.setBackground(Color.green);
                break;
            }
            default: {
                this.anchor.setBackground(Color.red);
            }
        }
    }

    void onCreate(QueryBuilder builder) {
        this.setQueryToken(new QueryTokens.Join(this.primaryField.querytoken, "=", this.foreignField.querytoken));
        builder.browser.addFromClause(this.querytoken);
    }

    void onDestroy(QueryBuilder builder) {
        this.primaryField.unjoined();
        this.foreignField.unjoined();
        this.primaryEntity.doFlush();
        this.foreignEntity.doFlush();
        builder.browser.removeFromClause(this.querytoken);
    }

    void doResize() {
        try {
            int yFieldP = (int)this.primaryField.getLocationOnScreen().getY() - (int)this.primaryEntity.getLocationOnScreen().getY() + this.primaryEntity.getLocation().y;
            int yFieldF = (int)this.foreignField.getLocationOnScreen().getY() - (int)this.foreignEntity.getLocationOnScreen().getY() + this.foreignEntity.getLocation().y;
            int py = yFieldP + this.primaryField.getSize().height / 2;
            int fy = yFieldF + this.foreignField.getSize().height / 2;
            int px1 = this.primaryEntity.getLocation().x;
            int px2 = px1 + this.primaryEntity.getSize().width;
            int fx1 = this.foreignEntity.getLocation().x;
            int fx2 = fx1 + this.foreignEntity.getSize().width;
            int xMin = 0;
            int yMin = 0;
            int xMax = 0;
            int yMax = 0;
            if (px2 < fx1) {
                this.serie[0].x = px2;
                this.serie[0].y = py;
                this.serie[2].x = fx1;
                this.serie[2].y = fy;
                this.serie[1].x = (px2 + fx1) / 2;
                this.serie[1].y = (py + fy) / 2;
                xMin = px1;
                xMax = fx2;
            } else if (px1 > fx2) {
                this.serie[0].x = fx2;
                this.serie[0].y = fy;
                this.serie[2].x = px1;
                this.serie[2].y = py;
                this.serie[1].x = (fx2 + px1) / 2;
                this.serie[1].y = (py + fy) / 2;
                xMin = fx1;
                xMax = px2;
            } else {
                this.serie[0].x = px2;
                this.serie[0].y = py;
                this.serie[2].x = fx2;
                this.serie[2].y = fy;
                this.serie[1].x = Math.max(px2, fx2) + 30;
                this.serie[1].y = (py + fy) / 2;
                xMin = Math.min(px2, fx2);
                xMax = this.serie[1].x;
            }
            yMin = Math.min(py, fy);
            yMax = Math.max(py, fy);
            Rectangle area = new Rectangle(xMin, yMin, xMax - xMin + 1, yMax - yMin + 1);
            for (int i = 0; i < this.serie.length; ++i) {
                this.serie[i].x -= area.x;
                this.serie[i].y -= area.y;
            }
            this.setBounds(area);
            this.anchor.setLocation(this.serie[1].x + area.x - this.anchor.getSize().width / 2, this.serie[1].y + area.y - this.anchor.getSize().height / 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        g.setColor(this.isHighlight() ? highlightColor : normalColor);
        ((Graphics2D)g).setStroke(this.isHighlight() ? highlightStroke : normalStroke);
        int arc_w = this.serie[2].x - this.serie[0].x;
        int arc_h = this.serie[2].y - this.serie[0].y;
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.serie[0].x > this.serie[1].x || this.serie[2].x > this.serie[1].x) {
            if (arc_h == 0) {
                g.drawLine(this.serie[0].x, this.serie[0].y, this.serie[2].x, this.serie[2].y);
            } else if (arc_h < 0) {
                g.drawArc(this.serie[0].x - arc_w / 2, this.serie[0].y + arc_h, arc_w, -arc_h, 270, 90);
                g.drawArc(this.serie[0].x + arc_w / 2, this.serie[0].y + arc_h, arc_w, -arc_h, 180, -90);
            } else if (arc_h > 0) {
                g.drawArc(this.serie[0].x - arc_w / 2, this.serie[0].y, arc_w, arc_h, 0, 90);
                g.drawArc(this.serie[0].x + arc_w / 2, this.serie[0].y, arc_w, arc_h, 180, 90);
            }
        } else if (arc_h == 0) {
            g.drawLine(this.serie[0].x, this.serie[0].y, this.serie[2].x, this.serie[2].y);
        } else if (arc_h < 0) {
            arc_w = this.serie[1].x - this.serie[0].x;
            arc_h = this.serie[0].y - this.serie[1].y;
            g.drawArc(this.serie[0].x - arc_w, this.serie[1].y - arc_h, arc_w * 2, arc_h * 2, 270, 90);
            arc_w = this.serie[1].x - this.serie[2].x;
            arc_h = this.serie[1].y - this.serie[2].y;
            g.drawArc(this.serie[2].x - arc_w, this.serie[2].y, arc_w * 2, arc_h * 2, 90, -90);
        } else if (arc_h > 0) {
            arc_w = this.serie[1].x - this.serie[0].x;
            arc_h = this.serie[1].y - this.serie[0].y;
            g.drawArc(this.serie[0].x - arc_w, this.serie[0].y, arc_w * 2, arc_h * 2, 90, -90);
            arc_w = this.serie[1].x - this.serie[2].x;
            arc_h = this.serie[2].y - this.serie[1].y;
            g.drawArc(this.serie[2].x - arc_w, this.serie[1].y - arc_h, arc_w * 2, arc_h * 2, 270, 90);
        }
        super.paintChildren(g);
    }

    private class ActionRemove
    extends AbstractAction {
        ActionRemove() {
            super(I18n.getString("querybuilder.menu.remove", "remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DiagramRelation.this.owner.removeRelation(DiagramRelation.this);
        }
    }

    private class ActionEdit
    extends AbstractAction {
        ActionEdit() {
            super(I18n.getString("querybuilder.menu.edit", "edit..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new MaskJoin(DiagramRelation.this, DiagramRelation.this.owner.getBuilder()).showDialog();
        }
    }

    private class Anchor
    extends JPanel
    implements MouseListener {
        Anchor() {
            this.addMouseListener(this);
            this.setBorder(LineBorder.createBlackLineBorder());
            this.setBackground(Color.red);
            this.setOpaque(true);
            this.setSize(10, 10);
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (SwingUtilities.isRightMouseButton(me)) {
                JPopupMenu popup = new JPopupMenu();
                popup.add(new ActionEdit());
                popup.addSeparator();
                popup.add(new ActionRemove());
                popup.show(this, me.getX(), me.getY());
            } else if (me.getClickCount() == 2) {
                new ActionEdit().actionPerformed(new ActionEvent(this, 0, ""));
            }
            DiagramRelation.this.owner.setHighlight(DiagramRelation.this);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

