/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import nickyb.sqleonardo.querybuilder.BrowserItems;
import nickyb.sqleonardo.querybuilder.DiagramAbstractEntity;
import nickyb.sqleonardo.querybuilder.DiagramField;
import nickyb.sqleonardo.querybuilder.DiagramRelation;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.syntax.DerivedTable;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class DiagramQuery
extends DiagramAbstractEntity {
    private DerivedTable subquery;
    private QueryTokens.Table reference;
    private static ImageIcon icon;

    DiagramQuery(QueryBuilder builder, DerivedTable subquery) {
        super(builder);
        if (icon == null) {
            icon = new ImageIcon(this.getClass().getResource("/images/page_white_database.png"));
        }
        this.getHeaderMenu().setIcon(icon);
        this.setQueryToken(subquery);
    }

    @Override
    void onCreate() {
        this.builder.browser.addFromClause(this.subquery);
        this.doFlush();
    }

    @Override
    void onDestroy() {
        this.fireDeselectAll();
        this.builder.diagram.removeAllRelation(this);
        this.builder.browser.removeFromClause(this.subquery);
    }

    @Override
    protected Color getDefaultBackground() {
        return Color.red;
    }

    DiagramField addField(String label) {
        DiagramField df = new DiagramField(this, label);
        QueryTokens.Column ctoken = new QueryTokens.Column(this.getQueryToken(), label);
        df.setQueryToken(ctoken);
        this.addField(df);
        return df;
    }

    void removeField(String label) {
        DiagramField df = this.getField(label);
        this.removeField(df);
        this.queryItem.getQueryExpression().getQuerySpecification().removeSelectList(df.getQueryToken());
        ((BrowserItems.DefaultTreeItem)this.queryItem.getFirstChild()).removeChild(df.getQueryToken());
        this.builder.browser.reload(this.queryItem.getFirstChild());
        BrowserItems.FromTreeItem fromItem = (BrowserItems.FromTreeItem)this.queryItem.getChildAt(1);
        Component[] diagramObjects = fromItem.getDiagramObjects();
        if (diagramObjects != null) {
            ArrayList<Component> al = new ArrayList<Component>();
            for (int i = 0; i < diagramObjects.length; ++i) {
                if (diagramObjects[i] instanceof DiagramRelation) {
                    DiagramRelation rel = (DiagramRelation)diagramObjects[i];
                    if (rel.primaryField == df || rel.foreignField == df) {
                        rel.primaryField.unjoined();
                        rel.foreignField.unjoined();
                        this.queryItem.getQueryExpression().getQuerySpecification().removeFromClause(rel.getQueryToken());
                        for (int s = 0; s < 2; ++s) {
                            QueryTokens.Table qtoken = s == 0 ? rel.getQueryToken().getPrimary().getTable() : rel.getQueryToken().getForeign().getTable();
                            BrowserItems.DefaultTreeItem child = fromItem.findChild(qtoken);
                            if (child == null) continue;
                            ((BrowserItems.JoinHandler)((Object)child)).unjoined();
                            if (((BrowserItems.JoinHandler)((Object)child)).isJoined()) continue;
                            child.setUserObject(qtoken);
                            if (!(child instanceof BrowserItems.TableTreeItem)) continue;
                            this.queryItem.getQueryExpression().getQuerySpecification().addFromClause(qtoken);
                        }
                        continue;
                    }
                }
                al.add(diagramObjects[i]);
            }
            fromItem.setDiagramObjects(al.size() > 0 ? al.toArray(new Component[al.size()]) : null);
        }
    }

    @Override
    public QueryTokens.Table getQueryToken() {
        return this.reference;
    }

    public void setQueryToken(DerivedTable subquery) {
        this.subquery = subquery;
        this.getHeaderMenu().setText(subquery.getAlias());
        this.reference = new QueryTokens.Table(null, null);
        this.reference.setAlias(subquery.getAlias());
        this.pack();
    }
}

