/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.querybuilder.BrowserItems;
import nickyb.sqleonardo.querybuilder.DiagramEntity;
import nickyb.sqleonardo.querybuilder.DiagramField;
import nickyb.sqleonardo.querybuilder.DiagramQuery;
import nickyb.sqleonardo.querybuilder.MaskAlias;
import nickyb.sqleonardo.querybuilder.MaskCondition;
import nickyb.sqleonardo.querybuilder.MaskExpression;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.syntax.DerivedTable;
import nickyb.sqleonardo.querybuilder.syntax.QueryExpression;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax.SubQuery;

public class BrowserPopup
extends JPopupMenu
implements MouseListener {
    private QueryBuilder builder;
    private QueryTokens._Base token;
    private DefaultMutableTreeNode node;
    private static final int POP_IDX_DISTINCT = 0;
    private static final int POP_IDX_ADD_E = 2;
    private static final int POP_IDX_ADD_S = 3;
    private static final int POP_IDX_ADD_W = 4;
    private static final int POP_IDX_ADD_G = 5;
    private static final int POP_IDX_ADD_H = 6;
    private static final int POP_IDX_ADD_O = 7;
    private static final int POP_IDX_ADD_U = 8;
    private static final int POP_IDX_EDIT = 10;
    private static final int POP_IDX_REM = 12;
    private static final int POP_IDX_REM_ALL = 14;

    BrowserPopup(QueryBuilder builder) {
        this.builder = builder;
        this.add(new MenuItemDistinct());
        this.addSeparator();
        this.add(new ActionAddExpression());
        this.add(new ActionAddSubquery());
        this.add(new ActionAddWhere());
        this.add(new ActionAddGroupBy());
        this.add(new ActionAddHaving());
        this.add(new ActionAddOrderBy());
        this.add(new ActionUnion());
        this.addSeparator();
        this.add(new ActionEditNode());
        this.addSeparator();
        this.add(new ActionRemoveNode());
        this.addSeparator();
        this.add(new ActionRemoveAll());
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.getClickCount() == 2) {
            if (this.token == null) {
                return;
            }
            ((JMenuItem)this.getComponent(10)).getAction().actionPerformed(null);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int row;
        JTree tree = (JTree)me.getSource();
        if (SwingUtilities.isRightMouseButton(me) && (row = tree.getRowForLocation(me.getX(), me.getY())) != -1) {
            tree.setSelectionRow(row);
        }
        this.node = null;
        this.token = null;
        TreePath path = tree.getSelectionPath();
        if (path != null) {
            QueryExpression qe;
            this.node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (this.node.getUserObject() instanceof QueryTokens._Base || this.node instanceof BrowserItems.TableTreeItem) {
                this.token = (QueryTokens._Base)this.node.getUserObject();
            } else if (this.node instanceof BrowserItems.ConditionQueryTreeItem) {
                this.token = ((BrowserItems.ConditionQueryTreeItem)this.node).getCondition();
            } else if (this.node instanceof BrowserItems.AbstractQueryTreeItem && (qe = ((BrowserItems.AbstractQueryTreeItem)this.node).getQueryExpression()) instanceof SubQuery) {
                this.token = (SubQuery)qe;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        JTree tree;
        TreePath path;
        if (SwingUtilities.isRightMouseButton(me) && (path = (tree = (JTree)me.getSource()).getSelectionPath()) != null) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                this.getComponent(i).setVisible(false);
            }
            if (this.node instanceof BrowserItems.FromTreeItem) {
                this.getComponent(3).setVisible(true);
            }
            if (this.node instanceof BrowserItems.DefaultTreeItem && ((BrowserItems.DefaultTreeItem)this.node).isQueryToken()) {
                boolean isEditable = !(this.token instanceof QueryTokens.Group);
                boolean isRemovable = !(this.token instanceof QueryTokens.Table);
                this.getComponent(5).setVisible(this.token instanceof QueryTokens._Expression);
                this.getComponent(7).setVisible(this.token instanceof QueryTokens._Expression);
                this.getComponent(9).setVisible(this.token instanceof QueryTokens._Expression);
                this.getComponent(10).setVisible(true);
                this.getComponent(10).setEnabled(isEditable);
                this.getComponent(11).setVisible(true);
                this.getComponent(12).setVisible(true);
                this.getComponent(12).setEnabled(isRemovable);
                this.getComponent(7).setEnabled(this.builder.browser.getQueryItem().toString().indexOf("ROOT") != -1);
            }
            if (this.node instanceof BrowserItems.AbstractQueryTreeItem) {
                this.getComponent(8).setVisible(true);
                this.getComponent(9).setVisible(this.getComponent(10).isVisible());
                this.getComponent(11).setVisible(true);
                this.getComponent(12).setVisible(true);
                this.getComponent(8).setEnabled(this.builder.browser.getQueryExpression().getUnion() == null);
                this.getComponent(12).setEnabled(this.node.toString().indexOf("ROOT") == -1);
            }
            if (this.node instanceof BrowserItems.ClauseTreeItem) {
                if (this.node.getUserObject().toString().indexOf("SELECT") != -1) {
                    this.getComponent(0).setVisible(true);
                    this.getComponent(1).setVisible(true);
                    this.getComponent(2).setVisible(true);
                    this.getComponent(3).setVisible(true);
                    ((JCheckBoxMenuItem)this.getComponent(0)).setSelected(this.node.getUserObject().toString().indexOf("DISTINCT") != -1);
                }
                this.getComponent(6).setVisible(this.node.getUserObject().toString().indexOf("HAVING") != -1);
                this.getComponent(4).setVisible(this.node.getUserObject().toString().indexOf("WHERE") != -1);
                boolean oneAddVisible = this.getComponent(4).isVisible() || this.getComponent(6).isVisible();
                boolean areAllRemovable = !this.getComponent(2).isVisible();
                this.getComponent(13).setVisible(oneAddVisible);
                this.getComponent(14).setVisible(areAllRemovable);
                this.getComponent(14).setEnabled(this.node.getChildCount() > 0);
            }
            this.show(tree, me.getX(), me.getY());
        }
    }

    class ActionRemoveAll
    extends AbstractAction {
        ActionRemoveAll() {
            super(I18n.getString("querybuilder.menu.removeAll", "remove all"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BrowserPopup.this.node.toString().indexOf("WHERE") != -1) {
                this.removeWhereClause();
            } else if (BrowserPopup.this.node.toString().indexOf("GROUP BY") != -1) {
                this.removeGroupByClause();
            } else if (BrowserPopup.this.node.toString().indexOf("HAVING") != -1) {
                this.removeHavingClause();
            } else if (BrowserPopup.this.node.toString().indexOf("ORDER BY") != -1) {
                this.removeOrderByClause();
            }
        }

        private void removeWhereClause() {
            DefaultMutableTreeNode where = BrowserPopup.this.node;
            while (where.getChildCount() > 0) {
                BrowserItems.DefaultTreeItem item = (BrowserItems.DefaultTreeItem)where.getFirstChild();
                ((BrowserPopup)BrowserPopup.this).builder.browser.setSelectedItem(item);
                if (item instanceof BrowserItems.ConditionQueryTreeItem) {
                    ((BrowserPopup)BrowserPopup.this).builder.browser.removeWhereClause(((BrowserItems.ConditionQueryTreeItem)item).getCondition());
                    continue;
                }
                ((BrowserPopup)BrowserPopup.this).builder.browser.removeWhereClause((QueryTokens.Condition)item.getUserObject());
            }
        }

        private void removeGroupByClause() {
            while (BrowserPopup.this.node.getChildCount() > 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)BrowserPopup.this.node.getFirstChild();
                ((BrowserPopup)BrowserPopup.this).builder.browser.removeGroupByClause((QueryTokens.Group)child.getUserObject());
            }
        }

        private void removeHavingClause() {
            DefaultMutableTreeNode where = BrowserPopup.this.node;
            while (where.getChildCount() > 0) {
                BrowserItems.DefaultTreeItem item = (BrowserItems.DefaultTreeItem)where.getFirstChild();
                ((BrowserPopup)BrowserPopup.this).builder.browser.setSelectedItem(item);
                if (item instanceof BrowserItems.ConditionQueryTreeItem) {
                    ((BrowserPopup)BrowserPopup.this).builder.browser.removeHavingClause(((BrowserItems.ConditionQueryTreeItem)item).getCondition());
                    continue;
                }
                ((BrowserPopup)BrowserPopup.this).builder.browser.removeHavingClause((QueryTokens.Condition)item.getUserObject());
            }
        }

        private void removeOrderByClause() {
            while (BrowserPopup.this.node.getChildCount() > 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)BrowserPopup.this.node.getFirstChild();
                ((BrowserPopup)BrowserPopup.this).builder.browser.removeOrderByClause((QueryTokens.Sort)child.getUserObject());
            }
        }
    }

    class ActionRemoveNode
    extends AbstractAction {
        ActionRemoveNode() {
            super(I18n.getString("querybuilder.menu.remove", "remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BrowserPopup.this.token instanceof QueryTokens.Condition) {
                if (BrowserPopup.this.node.getParent().toString().indexOf("WHERE") != -1) {
                    ((BrowserPopup)BrowserPopup.this).builder.browser.removeWhereClause((QueryTokens.Condition)BrowserPopup.this.token);
                } else {
                    ((BrowserPopup)BrowserPopup.this).builder.browser.removeHavingClause((QueryTokens.Condition)BrowserPopup.this.token);
                }
            } else if (BrowserPopup.this.token instanceof QueryTokens.Column) {
                DiagramField field;
                QueryTokens.Column c = (QueryTokens.Column)BrowserPopup.this.token;
                ((BrowserPopup)BrowserPopup.this).builder.browser.removeSelectList(c);
                DiagramEntity entity = ((BrowserPopup)BrowserPopup.this).builder.diagram.getEntity(c.getTable());
                if (entity != null && (field = entity.getField(c.getName())) != null) {
                    field.setSelected(false);
                }
            } else if (BrowserPopup.this.token instanceof QueryTokens.DefaultExpression) {
                ((BrowserPopup)BrowserPopup.this).builder.browser.removeSelectList((QueryTokens._Expression)BrowserPopup.this.token);
                BrowserItems.AbstractQueryTreeItem qti = ((BrowserPopup)BrowserPopup.this).builder.browser.getQueryItem();
                if (qti instanceof BrowserItems.DiagramQueryTreeItem) {
                    DiagramQuery entityUp = ((BrowserItems.DiagramQueryTreeItem)qti).getDiagramObject();
                    entityUp.removeField(((QueryTokens.DefaultExpression)BrowserPopup.this.token).getAlias());
                    entityUp.pack();
                }
            } else if (BrowserPopup.this.token instanceof QueryTokens.Group) {
                ((BrowserPopup)BrowserPopup.this).builder.browser.removeGroupByClause((QueryTokens.Group)BrowserPopup.this.token);
            } else if (BrowserPopup.this.token instanceof QueryTokens.Sort) {
                ((BrowserPopup)BrowserPopup.this).builder.browser.removeOrderByClause((QueryTokens.Sort)BrowserPopup.this.token);
            } else if (BrowserPopup.this.node instanceof BrowserItems.AbstractQueryTreeItem) {
                if (BrowserPopup.this.node instanceof BrowserItems.DiagramQueryTreeItem) {
                    BrowserItems.DiagramQueryTreeItem dqti = (BrowserItems.DiagramQueryTreeItem)BrowserPopup.this.node;
                    ((BrowserPopup)BrowserPopup.this).builder.browser.setSelectedItem((BrowserItems.DefaultTreeItem)dqti.getParent());
                    dqti.getDiagramObject().dispose();
                } else if (BrowserPopup.this.token instanceof QueryTokens._Expression) {
                    ((BrowserPopup)BrowserPopup.this).builder.browser.removeSelectList((QueryTokens._Expression)BrowserPopup.this.token);
                } else if (BrowserPopup.this.node instanceof BrowserItems.UnionQueryTreeItem) {
                    ((BrowserPopup)BrowserPopup.this).builder.browser.setUnion(null);
                }
            }
        }
    }

    class ActionEditNode
    extends AbstractAction {
        ActionEditNode() {
            super(I18n.getString("querybuilder.menu.edit", "edit..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object sort;
            int ret = -1;
            if (BrowserPopup.this.token instanceof QueryTokens.AbstractDatabaseObject) {
                if (new MaskAlias((QueryTokens.AbstractDatabaseObject)((Object)BrowserPopup.this.token), BrowserPopup.this.builder).showDialog()) {
                    ret = 0;
                }
            } else if (BrowserPopup.this.token instanceof QueryTokens.Condition) {
                if (new MaskCondition((QueryTokens.Condition)BrowserPopup.this.token, BrowserPopup.this.builder).showDialog()) {
                    ret = 0;
                }
            } else if (BrowserPopup.this.token instanceof QueryTokens.DefaultExpression) {
                if (new MaskExpression((QueryTokens.DefaultExpression)BrowserPopup.this.token, BrowserPopup.this.builder).showDialog()) {
                    ret = 0;
                }
            } else if (BrowserPopup.this.token instanceof QueryTokens.Sort && (sort = JOptionPane.showInputDialog(SwingUtilities.getWindowAncestor(BrowserPopup.this.builder), ((QueryTokens.Sort)BrowserPopup.this.token).toString().substring(0, ((QueryTokens.Sort)BrowserPopup.this.token).toString().lastIndexOf(32)), "order.edit", -1, null, new String[]{"ASC", "DESC"}, ((QueryTokens.Sort)BrowserPopup.this.token).isAscending() ? "ASC" : "DESC")) != null) {
                ((QueryTokens.Sort)BrowserPopup.this.token).setType(sort.toString().equals("ASC") ? (short)0 : 1);
                ret = 0;
            }
            if (ret == 0) {
                ((BrowserPopup)BrowserPopup.this).builder.browser.refreshSelection();
            }
        }
    }

    class ActionUnion
    extends AbstractAction {
        ActionUnion() {
            super(I18n.getString("querybuilder.menu.union", "union"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((BrowserPopup)BrowserPopup.this).builder.browser.setUnion(new QueryExpression());
        }
    }

    class ActionAddSubquery
    extends AbstractAction {
        ActionAddSubquery() {
            super(I18n.getString("querybuilder.menu.addSubquery", "add subquery"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BrowserPopup.this.node instanceof BrowserItems.FromTreeItem) {
                DerivedTable qtoken = new DerivedTable();
                DiagramQuery entity = new DiagramQuery(BrowserPopup.this.builder, qtoken);
                ((BrowserPopup)BrowserPopup.this).builder.diagram.addEntity(entity);
            } else {
                ((BrowserPopup)BrowserPopup.this).builder.browser.addSelectList(new SubQuery());
            }
        }
    }

    class ActionAddHaving
    extends ActionAddCondition {
        ActionAddHaving() {
        }

        @Override
        void add(QueryTokens.Condition token) {
            ((BrowserPopup)BrowserPopup.this).builder.browser.addHavingClause(token);
        }

        @Override
        QueryTokens.Condition createQueryToken() {
            QueryTokens.Condition token = new QueryTokens.Condition();
            if (((BrowserPopup)BrowserPopup.this).builder.browser.getQuerySpecification().getHavingClause().length > 0) {
                token.setAppend("AND");
            }
            return token;
        }
    }

    class ActionAddWhere
    extends ActionAddCondition {
        ActionAddWhere() {
        }

        @Override
        void add(QueryTokens.Condition token) {
            ((BrowserPopup)BrowserPopup.this).builder.browser.addWhereClause(token);
        }

        @Override
        QueryTokens.Condition createQueryToken() {
            QueryTokens.Condition token = new QueryTokens.Condition();
            if (((BrowserPopup)BrowserPopup.this).builder.browser.getQuerySpecification().getWhereClause().length > 0) {
                token.setAppend("AND");
            }
            return token;
        }
    }

    abstract class ActionAddCondition
    extends AbstractAction {
        ActionAddCondition() {
            super(I18n.getString("querybuilder.menu.addCondition", "add condition..."));
        }

        abstract void add(QueryTokens.Condition var1);

        abstract QueryTokens.Condition createQueryToken();

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryTokens.Condition token = this.createQueryToken();
            if (new MaskCondition(token, BrowserPopup.this.builder).showDialog()) {
                this.add(token);
            }
        }
    }

    class ActionAddExpression
    extends AbstractAction {
        ActionAddExpression() {
            super(I18n.getString("querybuilder.menu.addExpression", "add expression..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryTokens.DefaultExpression token = new QueryTokens.DefaultExpression(null);
            if (new MaskExpression(token, BrowserPopup.this.builder).showDialog()) {
                BrowserItems.AbstractQueryTreeItem qti = ((BrowserPopup)BrowserPopup.this).builder.browser.getQueryItem();
                if (qti instanceof BrowserItems.DiagramQueryTreeItem) {
                    DiagramQuery entityUp = ((BrowserItems.DiagramQueryTreeItem)qti).getDiagramObject();
                    entityUp.addField(token.getAlias());
                    entityUp.pack();
                }
                ((BrowserPopup)BrowserPopup.this).builder.browser.addSelectList(token);
            }
        }
    }

    class ActionAddOrderBy
    extends AbstractAction {
        ActionAddOrderBy() {
            super(I18n.getString("querybuilder.menu.addToOrderBy", "add to order-by"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((BrowserPopup)BrowserPopup.this).builder.browser.addOrderByClause(new QueryTokens.Sort((QueryTokens._Expression)BrowserPopup.this.token));
        }
    }

    class ActionAddGroupBy
    extends AbstractAction {
        ActionAddGroupBy() {
            super(I18n.getString("querybuilder.menu.addToGroupBy", "add to group-by"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((BrowserPopup)BrowserPopup.this).builder.browser.addGroupByClause(new QueryTokens.Group((QueryTokens._Expression)BrowserPopup.this.token));
        }
    }

    class MenuItemDistinct
    extends JCheckBoxMenuItem
    implements ActionListener {
        MenuItemDistinct() {
            super("distinct");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            short q = 0;
            String uo = "SELECT";
            if (this.isSelected()) {
                uo = uo + " DISTINCT";
                q = 2;
            }
            BrowserPopup.this.node.setUserObject(uo);
            ((BrowserPopup)BrowserPopup.this).builder.browser.getQuerySpecification().setQuantifier(q);
            ((BrowserPopup)BrowserPopup.this).builder.browser.refreshSelection();
        }
    }
}

