/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.util.Vector;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.mdi.MDIActions;
import nickyb.sqleonardo.environment.mdi.MDIClient;

public class MDIMenubar
extends JMenuBar
implements InternalFrameListener {
    static final int IDX_ACTIONS = 1;
    static final int IDX_TOOLS = 2;
    static final int IDX_WINDOW = 3;
    public History history = new History();
    private WindowGroup winGroup = new WindowGroup();

    public MDIMenubar() {
        JMenu menu = this.add("file");
        menu.setMnemonic('f');
        menu.add(MDIMenubar.createItem("action.052"));
        menu.add(MDIMenubar.createItem("action.053"));
        menu.addSeparator();
        menu.add(MDIMenubar.createItem(new MDIActions.Dummy("print..."))).setEnabled(false);
        menu.addSeparator();
        menu.add(MDIMenubar.createItem("action.051"));
        menu = this.add("actions");
        menu.setMnemonic('a');
        menu.add("<empty>").setEnabled(false);
        menu = this.add("tools");
        menu.setMnemonic('t');
        menu.add(this.winGroup.add("action.101"));
        menu.add(this.winGroup.add("action.102"));
        menu.add(this.winGroup.add("action.103"));
        menu.addSeparator();
        menu.add(MDIMenubar.createItem("action.104"));
        menu.add(MDIMenubar.createItem("action.105"));
        menu.addSeparator();
        menu.add(MDIMenubar.createItem("action.100"));
        menu = this.add("window");
        menu.setMnemonic('w');
        menu.add(MDIMenubar.createItem("action.110"));
        menu.add(MDIMenubar.createItem("action.111"));
        menu.addSeparator();
        menu.add(MDIMenubar.createItem("action.112"));
        menu.addSeparator();
        menu.add("<empty>").setEnabled(false);
        menu = this.add("?");
        menu.add(MDIMenubar.createItem(new MDIActions.Dummy("how to..."))).setEnabled(false);
        menu.addSeparator();
        menu.add(MDIMenubar.createItem("action.050"));
    }

    private JMenu add(String text) {
        return this.add(new JMenu(text));
    }

    private static JMenuItem createItem(String actionkey) {
        return MDIMenubar.createItem(Application.window.getAction(actionkey));
    }

    public static JMenuItem createItem(Action a) {
        JMenuItem item = new JMenuItem(a);
        item.setToolTipText(null);
        item.setIcon(null);
        if (a.getValue("AcceleratorKey") != null) {
            item.setAccelerator((KeyStroke)a.getValue("AcceleratorKey"));
        }
        return item;
    }

    Action getActionForShow(String clientName) {
        Action action = null;
        for (int i = 6; i < this.getMenu(3).getMenuComponentCount(); ++i) {
            JMenuItem item = (JMenuItem)this.getMenu(3).getMenuComponent(i);
            if (!((ActionShowMDIClient)item.getAction()).getMDIClientName().equals(clientName)) continue;
            action = item.getAction();
            break;
        }
        if (action == null && clientName.equals("metadata explorer")) {
            action = Application.window.getAction("action.101");
        }
        if (action == null && clientName.equals("command editor")) {
            action = Application.window.getAction("action.102");
        }
        if (action == null && clientName.equals("schema comparer")) {
            action = Application.window.getAction("action.103");
        }
        return action;
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent ife) {
        JRadioButtonMenuItem item;
        int i;
        this.getMenu(1).getMenuComponent(0).setVisible(true);
        while (this.getMenu(1).getMenuComponentCount() > 1) {
            this.getMenu(1).remove(1);
        }
        MDIClient client = (MDIClient)ife.getInternalFrame();
        this.history.onSelectionChanged(client);
        if (client.getMenuActions() != null) {
            for (i = 0; i < client.getMenuActions().length; ++i) {
                if (client.getMenuActions()[i] == null) {
                    this.getMenu(1).addSeparator();
                    continue;
                }
                this.getMenu(1).add(client.getMenuActions()[i]);
            }
            this.getMenu(1).getMenuComponent(0).setVisible(false);
        }
        for (i = 0; i < this.getMenu(2).getMenuComponentCount(); ++i) {
            if (!(this.getMenu(2).getMenuComponent(i) instanceof JRadioButtonMenuItem) || !((MDIActions.AbstractShow)(item = (JRadioButtonMenuItem)this.getMenu(2).getMenuComponent(i)).getAction()).getMDIClientName().equals(client.getName())) continue;
            item.setSelected(true);
        }
        for (i = 0; i < this.getMenu(3).getMenuComponentCount(); ++i) {
            if (!(this.getMenu(3).getMenuComponent(i) instanceof JRadioButtonMenuItem) || !((MDIActions.AbstractShow)(item = (JRadioButtonMenuItem)this.getMenu(3).getMenuComponent(i)).getAction()).getMDIClientName().equals(client.getName())) continue;
            item.setSelected(true);
        }
        Application.window.toolbar.onMDIClientActivated(client);
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent ife) {
        MDIClient client = (MDIClient)ife.getInternalFrame();
        this.history.remove(client);
        for (int i = 6; i < this.getMenu(3).getMenuComponentCount(); ++i) {
            JMenuItem item = (JMenuItem)this.getMenu(3).getMenuComponent(i);
            if (!((ActionShowMDIClient)item.getAction()).getMDIClientName().equals(client.getName())) continue;
            this.getMenu(3).remove(i);
            break;
        }
        this.getMenu(3).getMenuComponent(5).setVisible(this.getMenu(3).getMenuComponentCount() == 6);
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent ife) {
        MDIClient client = (MDIClient)ife.getInternalFrame();
        this.history.add(client);
        if (!client.isClosable()) {
            return;
        }
        this.getMenu(3).add(this.winGroup.add(client));
        this.getMenu(3).getMenuComponent(5).setVisible(false);
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent ife) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent ife) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent ife) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent ife) {
    }

    class History {
        private int current = -1;
        private boolean enabled = false;
        private Vector sequence = new Vector();

        History() {
        }

        void add(MDIClient client) {
            this.enabled = false;
            int i = this.current + 1;
            while (i < this.sequence.size()) {
                this.sequence.removeElementAt(i);
            }
            this.sequence.addElement(client);
            this.current = this.sequence.size() - 1;
        }

        void previous() {
            MDIClient back;
            Action action;
            this.enabled = false;
            if (this.current > 0) {
                --this.current;
            }
            if ((action = Application.window.menubar.getActionForShow((back = (MDIClient)this.sequence.elementAt(this.current)).getName())) != null) {
                action.actionPerformed(null);
            }
        }

        void enableSequence() {
            this.enabled = true;
        }

        void onSelectionChanged(MDIClient client) {
            if (this.enabled) {
                this.add(client);
            }
            this.enableActions();
        }

        void enableActions() {
            Application.window.getAction("action.113").setEnabled(this.current > 0);
            Application.window.getAction("action.114").setEnabled(this.current < this.sequence.size() - 1);
        }

        void next() {
            MDIClient forward;
            Action action;
            this.enabled = false;
            if ((action = Application.window.menubar.getActionForShow((forward = (MDIClient)this.sequence.elementAt(++this.current)).getName())) != null) {
                action.actionPerformed(null);
            }
        }

        void remove(MDIClient client) {
            this.enabled = false;
            int found = -1;
            while ((found = this.sequence.indexOf(client)) != -1) {
                this.sequence.removeElementAt(found);
                if (found == this.current && this.sequence.size() > 0) {
                    this.previous();
                    continue;
                }
                if (found >= this.current) continue;
                --this.current;
            }
        }
    }

    private class WindowGroup
    extends ButtonGroup {
        private WindowGroup() {
        }

        JRadioButtonMenuItem add(MDIClient client) {
            return this.createItem(new ActionShowMDIClient(client));
        }

        JRadioButtonMenuItem add(String actionkey) {
            return this.createItem(Application.window.getAction(actionkey));
        }

        private JRadioButtonMenuItem createItem(Action a) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(a);
            item.setToolTipText(null);
            item.setIcon(null);
            this.add(item);
            if (a.getValue("AcceleratorKey") != null) {
                item.setAccelerator((KeyStroke)a.getValue("AcceleratorKey"));
            }
            return item;
        }
    }

    private class ActionShowMDIClient
    extends MDIActions.AbstractShow {
        private String clientname;

        ActionShowMDIClient(MDIClient client) {
            this.clientname = client.getName();
            this.setText(client.getTitle());
        }

        @Override
        public String getMDIClientName() {
            return this.clientname;
        }
    }
}

