/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.Preferences;
import nickyb.sqleonardo.environment._Constants;
import nickyb.sqleonardo.environment.ctrl.content.AbstractActionContent;
import nickyb.sqleonardo.environment.ctrl.define.TableMetaData;
import nickyb.sqleonardo.environment.mdi.ClientCommandEditor;
import nickyb.sqleonardo.environment.mdi.ClientContent;
import nickyb.sqleonardo.environment.mdi.ClientDefinition;
import nickyb.sqleonardo.environment.mdi.ClientMetadataExplorer;
import nickyb.sqleonardo.environment.mdi.ClientQueryBuilder;
import nickyb.sqleonardo.environment.mdi.ClientSchemaComparer;
import nickyb.sqleonardo.environment.mdi.DialogAbout;
import nickyb.sqleonardo.environment.mdi.DialogPreferences;
import nickyb.sqleonardo.environment.mdi.DialogQuery;
import nickyb.sqleonardo.environment.mdi.DialogQuickObject;
import nickyb.sqleonardo.environment.mdi.MDIClient;
import nickyb.sqleonardo.querybuilder.DiagramLayout;
import nickyb.sqleonardo.querybuilder.syntax.QueryExpression;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public abstract class MDIActions
implements _Constants {

    public static class About
    extends AbstractBase {
        public About() {
            super(I18n.getFormattedString("application.menu.about", "about {0}...", new Object[]{"SQLeonardo"}));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            new DialogAbout().setVisible(true);
        }
    }

    public static class CloseAllClients
    extends AbstractBase {
        public CloseAllClients() {
            super(I18n.getString("application.menu.closeAll", "close all"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.window.closeAllClients();
            Application.window.menubar.history.enableActions();
        }
    }

    public static class TileClients
    extends AbstractBase {
        public TileClients() {
            super(I18n.getString("application.menu.tileHorizontal", "tile horizontal"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.window.tileClients();
        }
    }

    public static class CascadeClients
    extends AbstractBase {
        public CascadeClients() {
            super(I18n.getString("application.menu.cascade", "cascade"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.window.cascadeClients();
        }
    }

    public static class ShowSchemaComparer
    extends AbstractShowTool {
        public ShowSchemaComparer() {
            super(KeyStroke.getKeyStroke(51, 2), "icon.053");
        }

        @Override
        public String getMDIClientName() {
            return "schema comparer";
        }

        @Override
        protected MDIClient create() {
            return new ClientSchemaComparer();
        }
    }

    public static class ShowCommandEditor
    extends AbstractShowTool {
        public ShowCommandEditor() {
            super(KeyStroke.getKeyStroke(50, 2), "icon.052");
        }

        @Override
        public String getMDIClientName() {
            return "command editor";
        }

        @Override
        protected MDIClient create() {
            return new ClientCommandEditor();
        }
    }

    public static class ShowMetadataExplorer
    extends AbstractShowTool {
        public ShowMetadataExplorer() {
            super(KeyStroke.getKeyStroke(49, 2), "icon.051");
        }

        @Override
        public String getMDIClientName() {
            return "metadata explorer";
        }

        @Override
        protected MDIClient create() {
            return new ClientMetadataExplorer();
        }
    }

    public static abstract class AbstractShowTool
    extends AbstractShow {
        public AbstractShowTool(KeyStroke ks, String iconKey) {
            this.setAccelerator(ks);
            this.setIcon(iconKey);
            this.setTooltip(this.getMDIClientName());
            this.setText("show " + this.getMDIClientName());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!Application.window.showClient(this.getMDIClientName())) {
                Application.window.add(this.create());
            }
        }

        protected abstract MDIClient create();
    }

    public static abstract class AbstractShow
    extends AbstractBase {
        public abstract String getMDIClientName();

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae != null) {
                Application.window.menubar.history.enableSequence();
            }
            Application.window.showClient(this.getMDIClientName());
        }
    }

    public static class ShowPreferences
    extends AbstractBase {
        public ShowPreferences() {
            super("preferences...");
            this.setIcon("icon.050");
            this.setTooltip("edit preferences");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            new DialogPreferences().setVisible(true);
        }
    }

    public static class ShowDefinition
    extends AbstractBase {
        public ShowDefinition() {
            super(I18n.getString("application.tool.definition", "show definition..."));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object[] ret = DialogQuickObject.show("show definition");
            if (ret == null) {
                return;
            }
            String schema = ret[1] == null ? null : ret[1].toString();
            Application.window.add(new ClientDefinition(ret[0].toString(), new QueryTokens.Table(schema, ret[2].toString()), "TABLE"));
        }
    }

    public static class ShowContent
    extends AbstractActionContent {
        private TableMetaData tmd = null;

        public ShowContent() {
            this.putValue("Name", I18n.getString("application.tool.content", "show content..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tmd = null;
            super.actionPerformed(e);
        }

        @Override
        protected void onActionPerformed(int records, int option) {
            if (option == 2 || records == 0 && option == 1) {
                return;
            }
            boolean retrieve = records > 0 && option == 0;
            ClientContent client = new ClientContent(this.getTableMetaData(), retrieve);
            client.setTitle("CONTENT : " + this.getTableMetaData() + " : " + this.getTableMetaData().getHandlerKey());
            Application.window.add(client);
        }

        @Override
        protected TableMetaData getTableMetaData() {
            Object[] ret;
            if (this.tmd == null && (ret = DialogQuickObject.show("show content")) != null) {
                this.tmd = new TableMetaData(ret[0].toString(), ret[1] == null ? null : ret[1].toString(), ret[2].toString());
            }
            return this.tmd;
        }
    }

    public static class GoForward
    extends AbstractBase {
        public GoForward() {
            super("go forward");
            this.setIcon("icon.016");
            this.setTooltip("<empty>");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.window.menubar.history.next();
        }
    }

    public static class GoBack
    extends AbstractBase {
        public GoBack() {
            super("go back");
            this.setIcon("icon.015");
            this.setTooltip("<empty>");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.window.menubar.history.previous();
        }
    }

    public static class Exit
    extends AbstractBase {
        public Exit() {
            super(I18n.getString("application.menu.exit", "exit"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.shutdown();
        }
    }

    public static class LoadQuery
    extends AbstractBase {
        public LoadQuery() {
            super(I18n.getString("application.menu.loadQuery", "load query..."));
        }

        private void setSchema(String schema, QueryExpression qe) {
            int i;
            if (qe == null) {
                return;
            }
            QueryTokens._Base[] tokens = qe.getQuerySpecification().getSelectList();
            for (i = 0; i < tokens.length; ++i) {
                if (!(tokens[i] instanceof QueryTokens.Column)) continue;
                ((QueryTokens.Column)tokens[i]).getTable().setSchema(schema);
            }
            tokens = qe.getQuerySpecification().getFromClause();
            for (i = 0; i < tokens.length; ++i) {
                if (tokens[i] instanceof QueryTokens.Join) {
                    ((QueryTokens.Join)tokens[i]).getPrimary().getTable().setSchema(schema);
                    ((QueryTokens.Join)tokens[i]).getForeign().getTable().setSchema(schema);
                    continue;
                }
                ((QueryTokens.Table)tokens[i]).setSchema(schema);
            }
            this.setSchema(schema, qe.getUnion());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object[] ret = DialogQuery.showLoad();
            if (ret[0] != null && ret[1] != null && ret[2] != null) {
                ClientQueryBuilder cqb = new ClientQueryBuilder(ret[2].toString());
                cqb.setFileName(ret[0].toString());
                DiagramLayout dl = (DiagramLayout)ret[1];
                if (Preferences.getBoolean("querybuilder.use-schema")) {
                    if (dl.getQueryModel().getSchema() == null && ret[3] != null) {
                        int option = JOptionPane.showConfirmDialog(Application.window, "do you want to apply '" + ret[3] + "' schema on all elements?", "SQLeonardo", 1);
                        if (option == 0) {
                            this.setSchema(ret[3].toString(), dl.getQueryModel().getQueryExpression());
                        } else if (option == 2) {
                            return;
                        }
                    }
                } else if (dl.getQueryModel().getSchema() == null) {
                    if (ret[3] != null) {
                        dl.getQueryModel().setSchema(ret[3].toString());
                        this.setSchema(null, dl.getQueryModel().getQueryExpression());
                    }
                } else if (ret[3] != null) {
                    dl.getQueryModel().setSchema(ret[3].toString());
                }
                Application.window.add(cqb);
                cqb.setDiagramLayout(dl);
            }
        }
    }

    public static class NewQuery
    extends AbstractBase {
        public NewQuery() {
            super(I18n.getString("application.menu.newQuery", "new query"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!ConnectionAssistant.getHandlers().isEmpty()) {
                Object keycah = null;
                keycah = ConnectionAssistant.getHandlers().size() > 1 ? JOptionPane.showInputDialog(Application.window, I18n.getString("application.message.useConnection", "use connection:"), "SQLeonardo", -1, null, ConnectionAssistant.getHandlers().toArray(), null) : ConnectionAssistant.getHandlers().toArray()[0];
                if (keycah != null) {
                    ConnectionHandler ch;
                    ArrayList schemas;
                    DiagramLayout dl = new DiagramLayout();
                    if (!Preferences.getBoolean("querybuilder.use-schema") && (schemas = (ArrayList)(ch = ConnectionAssistant.getHandler(keycah.toString())).getObject("$schema_names")).size() > 0) {
                        Object schema = JOptionPane.showInputDialog(Application.window, I18n.getString("application.message.schema", "schema:"), "SQLeonardo", -1, null, schemas.toArray(), null);
                        if (schema == null) {
                            return;
                        }
                        dl.getQueryModel().setSchema(schema.toString());
                    }
                    ClientQueryBuilder cqb = new ClientQueryBuilder(keycah.toString());
                    cqb.setDiagramLayout(dl);
                    Application.window.add(cqb);
                }
            } else {
                Application.alert("SQLeonardo", I18n.getString("application.message.noConnection", "No connection!"));
            }
        }
    }

    public static final class Dummy
    extends AbstractAction {
        public Dummy(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Application.alert("SQLeonardo", "not implemented!");
        }
    }

    public static abstract class AbstractBase
    extends AbstractAction {
        public AbstractBase() {
        }

        public AbstractBase(String text) {
            super(text);
        }

        protected void setAccelerator(KeyStroke stroke) {
            this.putValue("AcceleratorKey", stroke);
        }

        protected void setIcon(String iconkey) {
            this.putValue("SmallIcon", Application.resources.getIcon(iconkey));
        }

        protected void setText(String text) {
            this.putValue("Name", text);
        }

        protected void setTooltip(String text) {
            this.putValue("ShortDescription", text);
        }
    }
}

