/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import nickyb.sqleonardo.common.gui.AbstractDialogConfirm;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.common.util.LocaleAdapter;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.Preferences;
import nickyb.sqleonardo.querybuilder.QueryBuilder;

public class DialogPreferences
extends AbstractDialogConfirm {
    private JCheckBox optQbAutoJoin;
    private JCheckBox optQbAutoAlias;
    private JCheckBox optQbUseQuote;
    private JCheckBox optQbUseSchema;
    private JCheckBox optQbLoadAtOnce;
    private JCheckBox optQbSelectAll;
    private JLabel jLabelLanguage = new JLabel();
    private JComboBox jComboBoxLanguage = new JComboBox();
    private JCheckBox jCheckBoxTrace = new JCheckBox();
    private JTextField jTextFieldMaxColSize = new JTextField();

    public DialogPreferences() {
        super((Component)Application.window, "SQLeonardo.preferences", 350, 355);
        JPanel pnlQB = new JPanel(new GridLayout(0, 1));
        pnlQB.setBorder(new EmptyBorder(10, 5, 90, 5));
        this.optQbAutoJoin = new JCheckBox(I18n.getString("application.preferences.autoJoin", "auto join"), Preferences.getBoolean("querybuilder.auto-join", true));
        pnlQB.add(this.optQbAutoJoin);
        this.optQbAutoAlias = new JCheckBox(I18n.getString("application.preferences.autoAlias", "auto alias"), Preferences.getBoolean("querybuilder.auto-alias", true));
        pnlQB.add(this.optQbAutoAlias);
        pnlQB.add(new JSeparator());
        this.optQbUseQuote = new JCheckBox(I18n.getString("application.preferences.alwaysQuoteIdentifiers", "always quote identifiers"), Preferences.getBoolean("querybuilder.use-quote", true));
        pnlQB.add(this.optQbUseQuote);
        this.optQbUseSchema = new JCheckBox(I18n.getString("application.preferences.useSchemaName", "use schema name in syntax definition"), Preferences.getBoolean("querybuilder.use-schema", true));
        pnlQB.add(this.optQbUseSchema);
        pnlQB.add(new JSeparator());
        this.optQbLoadAtOnce = new JCheckBox(I18n.getString("application.preferences.loadObjectsAtOnce", "load table objects list at once"), Preferences.getBoolean("querybuilder.load-objects-at-once", true));
        pnlQB.add(this.optQbLoadAtOnce);
        this.optQbSelectAll = new JCheckBox(I18n.getString("application.preferences.selectAllColumns", "aout select all colmuns"), Preferences.getBoolean("querybuilder.select-all-columns", true));
        pnlQB.add(this.optQbSelectAll);
        this.jLabelLanguage.setText(I18n.getString("application.preferences.language", "language"));
        List list = I18n.getListOfAvailLanguages();
        list.add(0, Locale.getDefault());
        if (!Locale.getDefault().equals(Locale.ENGLISH)) {
            list.add(1, Locale.ENGLISH);
        }
        int selectedItem = 0;
        for (int i = 0; i < list.size(); ++i) {
            Locale loc = (Locale)list.get(i);
            this.jComboBoxLanguage.addItem(new LocaleAdapter(loc));
            if (!I18n.getCurrentLocale().toString().equals(loc.toString())) continue;
            selectedItem = i;
        }
        this.jComboBoxLanguage.setSelectedIndex(selectedItem);
        this.jCheckBoxTrace.setText(I18n.getString("application.preferences.trace", "trace log (need restart)"));
        this.jCheckBoxTrace.setSelected(Preferences.getBoolean("application.trace", true));
        JPanel pnlGeneral = new JPanel(new GridLayout(0, 1));
        pnlGeneral.setBorder(new EmptyBorder(10, 5, 175, 5));
        pnlGeneral.add(this.jLabelLanguage);
        pnlGeneral.add(this.jComboBoxLanguage);
        pnlGeneral.add(this.jCheckBoxTrace);
        JPanel pnlCommand = new JPanel(new GridLayout(0, 1));
        pnlCommand.setBorder(new EmptyBorder(10, 5, 210, 5));
        pnlCommand.add(new JLabel(I18n.getString("application.preferences.maxcolsize", "Maximum column size:")));
        this.jTextFieldMaxColSize.setText(String.valueOf(Preferences.getInteger("editor.maxcolsize", 50)));
        pnlCommand.add(this.jTextFieldMaxColSize);
        JTabbedPane options = new JTabbedPane();
        options.addTab("general", pnlGeneral);
        options.addTab("command editor", pnlCommand);
        options.addTab("query builder", pnlQB);
        this.getContentPane().add(options);
    }

    @Override
    protected void onOpen() {
        Component[] items = Application.window.menubar.getMenu(3).getMenuComponents();
        for (int i = 0; i < items.length; ++i) {
            String txt;
            if (!(items[i] instanceof JMenuItem) || (txt = ((JMenuItem)items[i]).getText()).indexOf(" - QUERY : ") == -1) continue;
            this.optQbAutoAlias.setEnabled(false);
            this.optQbAutoJoin.setEnabled(false);
            this.optQbUseQuote.setEnabled(false);
            this.optQbUseSchema.setEnabled(false);
            this.optQbLoadAtOnce.setEnabled(false);
            this.optQbSelectAll.setEnabled(false);
            break;
        }
    }

    @Override
    protected boolean onConfirm() {
        QueryBuilder.autoJoin = this.optQbAutoJoin.isSelected();
        QueryBuilder.autoAlias = this.optQbAutoAlias.isSelected();
        QueryBuilder.useAlwaysQuote = this.optQbUseQuote.isSelected();
        QueryBuilder.loadObjectsAtOnce = this.optQbLoadAtOnce.isSelected();
        QueryBuilder.selectAllColumns = this.optQbSelectAll.isSelected();
        Preferences.set("querybuilder.auto-join", new Boolean(this.optQbAutoJoin.isSelected()));
        Preferences.set("querybuilder.auto-alias", new Boolean(this.optQbAutoAlias.isSelected()));
        Preferences.set("querybuilder.use-quote", new Boolean(this.optQbUseQuote.isSelected()));
        Preferences.set("querybuilder.use-schema", new Boolean(this.optQbUseSchema.isSelected()));
        Preferences.set("querybuilder.load-objects-at-once", new Boolean(this.optQbLoadAtOnce.isSelected()));
        Preferences.set("querybuilder.select-all-columns", new Boolean(this.optQbSelectAll.isSelected()));
        if (this.jComboBoxLanguage.getSelectedIndex() >= 0) {
            LocaleAdapter la = (LocaleAdapter)this.jComboBoxLanguage.getSelectedItem();
            I18n.setCurrentLocale(la.getLocale());
            Preferences.set("app.locale", la.getLocale().toString());
        }
        Preferences.set("application.trace", new Boolean(this.jCheckBoxTrace.isSelected()));
        Preferences.set("editor.maxcolsize", new Integer(this.jTextFieldMaxColSize.getText()));
        return true;
    }
}

