/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import nickyb.sqleonardo.common.gui.Toolbar;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.MetadataExplorer;
import nickyb.sqleonardo.environment.ctrl.explorer.DialogDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.DialogDriver;
import nickyb.sqleonardo.environment.mdi.MDIClient;
import nickyb.sqleonardo.environment.mdi.MDIMenubar;

public class ClientMetadataExplorer
extends MDIClient {
    public static final String DEFAULT_TITLE = "metadata explorer";
    private MetadataExplorer control = new MetadataExplorer();
    private JMenuItem[] m_actions;
    private Toolbar toolbar;

    ClientMetadataExplorer() {
        super(DEFAULT_TITLE);
        this.setComponentCenter(this.control);
        this.control.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.initMenuActions();
    }

    private void initMenuActions() {
        this.m_actions = new JMenuItem[]{MDIMenubar.createItem(this.control.getActionMap().get("choose-columns")), null, MDIMenubar.createItem(this.control.getActionMap().get("list-copy")), MDIMenubar.createItem(this.control.getActionMap().get("list-export")), null, MDIMenubar.createItem(this.control.getActionMap().get("list-refresh"))};
    }

    @Override
    public final void dispose() {
        this.control.unloadNavigator();
        super.dispose();
    }

    public final MetadataExplorer getControl() {
        return this.control;
    }

    @Override
    public final String getName() {
        return DEFAULT_TITLE;
    }

    @Override
    public JMenuItem[] getMenuActions() {
        return this.m_actions;
    }

    @Override
    public Toolbar getSubToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new Toolbar(0);
            this.toolbar.add(new ActionNewDriver());
            this.toolbar.add(new ActionNewDatasource()).setEnabled(false);
            this.toolbar.addSeparator();
            this.toolbar.add(new ActionDelete()).setEnabled(false);
        }
        return this.toolbar;
    }

    @Override
    protected void setPreferences() {
        this.control.setPreferences();
    }

    public void onSomethingChanged(boolean browsing) {
        this.toolbar.getAction(0).setEnabled(false);
        this.toolbar.getAction(1).setEnabled(false);
        this.toolbar.getAction(3).setEnabled(false);
        if (browsing) {
            this.toolbar.getAction(0).setEnabled(true);
            if (!this.control.getNavigator().isSelectionEmpty()) {
                this.toolbar.getAction(1).setEnabled(true);
                if (this.control.getNavigator().getSelectionPath().getPathCount() < 4) {
                    this.toolbar.getAction(3).setEnabled(true);
                }
            }
        }
    }

    private class ActionDelete
    extends AbstractAction {
        private ActionDelete() {
            this.putValue("ShortDescription", "delete selection");
            this.putValue("SmallIcon", Application.resources.getIcon("icon.014"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ClientMetadataExplorer.this.control.getNavigator().remove();
        }
    }

    private class ActionNewDatasource
    extends AbstractAction {
        private ActionNewDatasource() {
            this.putValue("ShortDescription", "new datasource...");
            this.putValue("SmallIcon", Application.resources.getIcon("icon.111"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ClientMetadataExplorer.this.control.getNavigator().isSelectionEmpty()) {
                Application.alert("SQLeonardo", "select one driver!");
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ClientMetadataExplorer.this.control.getNavigator().getSelectionPath().getPathComponent(1);
            ClientMetadataExplorer.this.control.getNavigator().setSelectionNode(node);
            DialogDatasource dlg = new DialogDatasource(ClientMetadataExplorer.this.control.getNavigator(), 0);
            dlg.setVisible(true);
        }
    }

    private class ActionNewDriver
    extends AbstractAction {
        private ActionNewDriver() {
            this.putValue("ShortDescription", "new driver...");
            this.putValue("SmallIcon", Application.resources.getIcon("icon.110"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DialogDriver dlg = new DialogDriver(ClientMetadataExplorer.this.control.getNavigator(), 0);
            dlg.setVisible(true);
        }
    }
}

