/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.sql.ResultSet;
import javax.swing.tree.DefaultMutableTreeNode;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.MetadataExplorer;
import nickyb.sqleonardo.environment.ctrl.define.ColumnsChooser;
import nickyb.sqleonardo.environment.ctrl.explorer.AbstractViewObjects;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDatasource;
import nickyb.sqleonardo.querybuilder.QueryBuilder;

public class ViewMetadata
extends AbstractViewObjects {
    private String keycah = null;
    private String schema = null;

    @Override
    protected String getHandlerKey() {
        if (ConnectionAssistant.hasHandler(this.keycah)) {
            QueryBuilder.identifierQuoteString = ConnectionAssistant.getHandler(this.keycah).getObject("$identifierQuoteString").toString();
            QueryBuilder.maxColumnNameLength = (Integer)ConnectionAssistant.getHandler(this.keycah).getObject("$maxColumnNameLength");
        }
        return this.keycah;
    }

    @Override
    protected String getTableSchema() {
        return this.schema;
    }

    protected void list(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        if (parent.getUserObject() instanceof UoDatasource) {
            UoDatasource uoDs = (UoDatasource)parent.getUserObject();
            this.schema = uoDs.schema;
        } else {
            this.schema = parent.getUserObject().toString();
            parent = (DefaultMutableTreeNode)parent.getParent();
        }
        this.keycah = ((UoDatasource)parent.getUserObject()).getKey();
        String[] tableType = node.getUserObject().toString().equals(MetadataExplorer.ALL_TABLE_TYPES_LABEL) ? null : new String[]{node.getUserObject().toString()};
        try {
            String dvname = node.getPath()[1].toString();
            String catalog = this.schema == null ? null : this.getConnection().getCatalog();
            ResultSet rs = this.getConnection().getMetaData().getTables(catalog, this.schema, "%", tableType);
            ColumnsChooser.list(dvname, "table types", this, rs);
        }
        catch (Exception e) {
            Application.println(e, true);
        }
    }
}

