/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import nickyb.sqleonardo.environment.Preferences;

public class MaskLibraryChooser
extends JFileChooser {
    MaskLibraryChooser() {
        String currentDirectory = Preferences.getString("lastDirectory", System.getProperty("user.home"));
        this.setCurrentDirectory(new File(currentDirectory));
        this.setBorder(null);
        this.setAcceptAllFileFilterUsed(false);
        this.setControlButtonsAreShown(false);
        this.setFileSelectionMode(0);
        this.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".jar") || file.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "library files (*.jar, *.zip)";
            }
        });
    }

    String getLibrary() {
        return this.isFileSelected() ? this.getSelectedFile().toString() : null;
    }

    public boolean isFileSelected() {
        return this.getSelectedFile() != null && this.getSelectedFile().isFile();
    }
}

