/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import nickyb.sqleonardo.common.gui.AbstractDialogConfirm;
import nickyb.sqleonardo.common.gui.ListView;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.mdi.DefaultMaskChooser;

public class DialogExport
extends AbstractDialogConfirm {
    private ListView lv;
    private DefaultMaskChooser mkc;

    public DialogExport(ListView lv) {
        super((Component)Application.window, "export list");
        this.lv = lv;
    }

    @Override
    protected boolean onConfirm() {
        File file = this.mkc.getSelectedFile();
        if (file == null) {
            return false;
        }
        try {
            int row;
            PrintStream out = new PrintStream(new FileOutputStream(file));
            StringBuffer header = new StringBuffer("| ");
            StringBuffer divider = new StringBuffer("+-");
            int[] columnDisplaySize = new int[this.lv.getColumnCount()];
            for (row = 0; row < this.lv.getRowCount(); ++row) {
                for (int col = 0; col < this.lv.getColumnCount(); ++col) {
                    Object value = this.lv.getValueAt(row, col);
                    if (value == null) {
                        value = new String();
                    }
                    if (value.toString().length() <= columnDisplaySize[col]) continue;
                    columnDisplaySize[col] = value.toString().length();
                }
            }
            for (int col = 0; col < this.lv.getColumnCount(); ++col) {
                header.append(this.lv.getColumnName(col));
                char[] filler = new char[this.lv.getColumnName(col).length()];
                Arrays.fill(filler, '-');
                divider.append(filler);
                int diff = columnDisplaySize[col] - this.lv.getColumnName(col).length();
                if (diff > 0) {
                    filler = new char[diff];
                    Arrays.fill(filler, ' ');
                    header.append(filler);
                    Arrays.fill(filler, '-');
                    divider.append(filler);
                } else {
                    columnDisplaySize[col] = this.lv.getColumnName(col).length();
                }
                header.append(" | ");
                divider.append("-+-");
            }
            divider.deleteCharAt(divider.length() - 1);
            header.deleteCharAt(header.length() - 1);
            out.println(divider.toString());
            out.println(header.toString());
            out.println(divider.toString());
            out.flush();
            for (row = 0; row < this.lv.getRowCount(); ++row) {
                StringBuffer line = new StringBuffer("| ");
                for (int col = 0; col < this.lv.getColumnCount(); ++col) {
                    int diff;
                    Object value = this.lv.getValueAt(row, col);
                    if (value == null) {
                        value = new String();
                    }
                    if ((diff = columnDisplaySize[col] - value.toString().length()) > 0) {
                        char[] filler = new char[diff];
                        Arrays.fill(filler, ' ');
                        line.append(value + new String(filler));
                    } else if (diff < 0) {
                        value = value.toString().substring(0, columnDisplaySize[col] - 3);
                        line.append(value + "...");
                    } else {
                        line.append(value);
                    }
                    line.append(" | ");
                }
                line.deleteCharAt(line.length() - 1);
                out.println(line.toString());
                out.flush();
            }
            out.println(divider.toString());
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            Application.alert("SQLeonardo", e.getMessage());
        }
        return true;
    }

    @Override
    protected void onOpen() {
        this.mkc = new DefaultMaskChooser(1, 0, true);
        this.getContentPane().add(this.mkc);
        this.getContentPane().validate();
    }
}

